/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegator;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.engine.backend.orchestration.spi.SingletonTask;
import org.hibernate.search.engine.reporting.FailureContext;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexWriterDelegatorImpl
implements IndexWriterDelegator {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexWriter delegate;
    private final EventContext eventContext;
    private final TimingSource timingSource;
    private final int commitInterval;
    private final FailureHandler failureHandler;
    private final SingletonTask delayedCommitTask;
    private final Object commitLock = new Object();
    private long commitExpiration;

    public IndexWriterDelegatorImpl(IndexWriter delegate, EventContext eventContext, ScheduledExecutorService delayedCommitExecutor, TimingSource timingSource, int commitInterval, FailureHandler failureHandler, DelayedCommitFailureHandler delayedCommitFailureHandler) {
        this.delegate = delegate;
        this.eventContext = eventContext;
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.failureHandler = failureHandler;
        this.delayedCommitTask = (long)commitInterval == 0L ? null : new SingletonTask("Delayed commit for " + eventContext.render(), (SingletonTask.Worker)new LuceneDelayedCommitWorker(delayedCommitFailureHandler), (SingletonTask.Scheduler)new LuceneDelayedCommitScheduler(delayedCommitExecutor), failureHandler);
        this.updateCommitExpiration();
    }

    @Override
    public long addDocuments(Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.delegate.addDocuments(docs);
    }

    @Override
    public long updateDocuments(Term term, Iterable<? extends Iterable<? extends IndexableField>> docs) throws IOException {
        return this.delegate.updateDocuments(term, docs);
    }

    @Override
    public long deleteDocuments(Term term) throws IOException {
        return this.delegate.deleteDocuments(new Term[]{term});
    }

    @Override
    public long deleteDocuments(Query query) throws IOException {
        return this.delegate.deleteDocuments(new Query[]{query});
    }

    public void mergeSegments() throws IOException {
        this.delegate.forceMerge(1);
    }

    public void commit() {
        this.doCommit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commitOrDelay() {
        if (!this.delegate.hasUncommittedChanges()) {
            return;
        }
        if (this.delayCommit()) {
            return;
        }
        Object object = this.commitLock;
        synchronized (object) {
            if (this.delayCommit()) {
                return;
            }
            this.doCommit();
        }
    }

    public DirectoryReader openReader() throws IOException {
        return DirectoryReader.open((IndexWriter)this.delegate);
    }

    public DirectoryReader openReaderIfChanged(DirectoryReader oldReader) throws IOException {
        return DirectoryReader.openIfChanged((DirectoryReader)oldReader, (IndexWriter)this.delegate);
    }

    public IndexWriter getDelegateForTests() {
        return this.delegate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() throws IOException {
        try (Closer closer = new Closer();){
            closer.push(SingletonTask::stop, (Object)this.delayedCommitTask);
            Object object = this.commitLock;
            synchronized (object) {
                closer.push(IndexWriter::close, (Object)this.delegate);
            }
            log.trace("IndexWriter closed");
        }
    }

    void closeAfterFailure(Throwable throwable, Object failingOperation) {
        SearchException exceptionToReport = log.uncommittedOperationsBecauseOfFailure(throwable.getMessage(), this.eventContext, throwable);
        try {
            this.close();
        }
        catch (IOException | RuntimeException e) {
            exceptionToReport.addSuppressed((Throwable)log.unableToCloseIndexWriterAfterFailures(this.eventContext, e));
        }
        FailureContext.Builder failureContextBuilder = FailureContext.builder();
        failureContextBuilder.throwable((Throwable)exceptionToReport);
        failureContextBuilder.failingOperation(failingOperation);
        FailureContext failureContext = failureContextBuilder.build();
        this.failureHandler.handle(failureContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCommit() {
        try {
            Object object = this.commitLock;
            synchronized (object) {
                this.delegate.commit();
                this.updateCommitExpiration();
            }
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCommitIndex(this.eventContext, e);
        }
    }

    private boolean delayCommit() {
        long timeToCommit = this.getTimeToCommit();
        if (timeToCommit <= 0L) {
            return false;
        }
        this.delayedCommitTask.ensureScheduled();
        return true;
    }

    private long getTimeToCommit() {
        if ((long)this.commitInterval == 0L) {
            return 0L;
        }
        return this.commitExpiration - this.timingSource.getMonotonicTimeEstimate();
    }

    private void updateCommitExpiration() {
        this.commitExpiration = this.commitInterval == 0 ? 0L : this.timingSource.getMonotonicTimeEstimate() + (long)this.commitInterval;
    }

    static interface DelayedCommitFailureHandler {
        public void handle(Throwable var1, Object var2);
    }

    private class LuceneDelayedCommitScheduler
    implements SingletonTask.Scheduler {
        private final ScheduledExecutorService delegate;

        private LuceneDelayedCommitScheduler(ScheduledExecutorService delegate) {
            this.delegate = delegate;
        }

        public Future<?> schedule(Runnable runnable) {
            return this.delegate.schedule(runnable, IndexWriterDelegatorImpl.this.getTimeToCommit(), TimeUnit.MILLISECONDS);
        }
    }

    private class LuceneDelayedCommitWorker
    implements SingletonTask.Worker {
        private final CompletableFuture<?> completedFuture = CompletableFuture.completedFuture(null);
        private final DelayedCommitFailureHandler delayedCommitFailureHandler;

        public LuceneDelayedCommitWorker(DelayedCommitFailureHandler delayedCommitFailureHandler) {
            this.delayedCommitFailureHandler = delayedCommitFailureHandler;
        }

        public CompletableFuture<?> work() {
            try {
                IndexWriterDelegatorImpl.this.commitOrDelay();
            }
            catch (Throwable t) {
                this.delayedCommitFailureHandler.handle(t, "Delayed commit");
            }
            return this.completedFuture;
        }

        public void complete() {
        }
    }
}

