/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.writer.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.HibernateSearchConcurrentMergeScheduler;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterConfigSource;
import org.hibernate.search.backend.lucene.lowlevel.writer.impl.IndexWriterDelegatorImpl;
import org.hibernate.search.backend.lucene.resources.impl.BackendThreads;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public class IndexWriterProvider {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String indexName;
    private final EventContext eventContext;
    private final DirectoryHolder directoryHolder;
    private final IndexWriterConfigSource configSource;
    private final TimingSource timingSource;
    private final int commitInterval;
    private BackendThreads threads;
    private final FailureHandler failureHandler;
    private final AtomicReference<IndexWriterDelegatorImpl> currentWriter = new AtomicReference();
    private final ReentrantLock currentWriterModificationLock = new ReentrantLock();

    public IndexWriterProvider(String indexName, EventContext eventContext, DirectoryHolder directoryHolder, IndexWriterConfigSource configSource, TimingSource timingSource, int commitInterval, BackendThreads threads, FailureHandler failureHandler) {
        this.indexName = indexName;
        this.eventContext = eventContext;
        this.directoryHolder = directoryHolder;
        this.configSource = configSource;
        this.timingSource = timingSource;
        this.commitInterval = commitInterval;
        this.threads = threads;
        this.failureHandler = failureHandler;
    }

    public void clear() throws IOException {
        IndexWriterDelegatorImpl indexWriterDelegator = this.currentWriter.getAndSet(null);
        if (indexWriterDelegator != null) {
            indexWriterDelegator.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAfterFailure(Throwable throwable, Object failingOperation) {
        log.indexWriterReset(this.eventContext);
        this.currentWriterModificationLock.lock();
        try {
            IndexWriterDelegatorImpl indexWriterDelegator = this.currentWriter.getAndSet(null);
            if (indexWriterDelegator != null) {
                indexWriterDelegator.closeAfterFailure(throwable, failingOperation);
            }
        }
        finally {
            this.currentWriterModificationLock.unlock();
        }
    }

    public IndexWriterDelegatorImpl getOrNull() {
        return this.currentWriter.get();
    }

    public IndexWriterDelegatorImpl getOrCreate() throws IOException {
        IndexWriterDelegatorImpl indexWriterDelegator = this.currentWriter.get();
        if (indexWriterDelegator == null) {
            this.currentWriterModificationLock.lock();
            try {
                indexWriterDelegator = this.currentWriter.get();
                if (indexWriterDelegator == null) {
                    IndexWriter indexWriter = this.createNewIndexWriter();
                    indexWriterDelegator = new IndexWriterDelegatorImpl(indexWriter, this.eventContext, this.threads.getWriteExecutor(), this.timingSource, this.commitInterval, this.failureHandler, this::clearAfterFailure);
                    log.trace("IndexWriter opened");
                    this.currentWriter.set(indexWriterDelegator);
                }
            }
            finally {
                this.currentWriterModificationLock.unlock();
            }
        }
        return indexWriterDelegator;
    }

    private IndexWriter createNewIndexWriter() throws IOException {
        IndexWriterConfig indexWriterConfig = this.createWriterConfig();
        return new IndexWriter(this.directoryHolder.get(), indexWriterConfig);
    }

    private IndexWriterConfig createWriterConfig() {
        IndexWriterConfig writerConfig = this.configSource.createIndexWriterConfig();
        HibernateSearchConcurrentMergeScheduler mergeScheduler = new HibernateSearchConcurrentMergeScheduler(this.indexName, this.eventContext.render(), this.threads.getThreadProvider(), this.failureHandler);
        writerConfig.setMergeScheduler((MergeScheduler)mergeScheduler);
        writerConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        return writerConfig;
    }
}

