/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.scope.model.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneScopeModel;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneDifferentNestedObjectCompatibilityChecker {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final LuceneScopeModel scopeModel;
    private final String fieldPath;
    private final List<String> nestedPathHierarchy;

    public static LuceneDifferentNestedObjectCompatibilityChecker empty(LuceneScopeModel scopeModel) {
        return new LuceneDifferentNestedObjectCompatibilityChecker(scopeModel, null, Collections.emptyList());
    }

    private LuceneDifferentNestedObjectCompatibilityChecker(LuceneScopeModel scopeModel, String fieldPath, List<String> nestedPathHierarchy) {
        this.scopeModel = scopeModel;
        this.fieldPath = fieldPath;
        this.nestedPathHierarchy = nestedPathHierarchy;
    }

    public LuceneDifferentNestedObjectCompatibilityChecker combineAndCheck(String incomingFieldPath) {
        List<String> incomingNestedPathHierarchy = this.scopeModel.getNestedPathHierarchyForField(incomingFieldPath);
        if (this.fieldPath == null) {
            return new LuceneDifferentNestedObjectCompatibilityChecker(this.scopeModel, incomingFieldPath, incomingNestedPathHierarchy);
        }
        if (!this.nestedPathHierarchy.equals(incomingNestedPathHierarchy)) {
            throw log.simpleQueryStringSpanningMultipleNestedPaths(this.fieldPath, LuceneDifferentNestedObjectCompatibilityChecker.getLastPath(this.nestedPathHierarchy), incomingFieldPath, LuceneDifferentNestedObjectCompatibilityChecker.getLastPath(incomingNestedPathHierarchy));
        }
        return this;
    }

    public List<String> getNestedPathHierarchy() {
        return this.nestedPathHierarchy;
    }

    private static String getLastPath(List<String> hierarchy) {
        if (hierarchy.isEmpty()) {
            return "<<root>>";
        }
        return hierarchy.get(hierarchy.size() - 1);
    }
}

