/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.hibernate.search.backend.lucene.lowlevel.common.impl.MetadataFields;
import org.hibernate.search.backend.lucene.scope.model.impl.LuceneCompatibilityChecker;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.backend.types.converter.runtime.spi.ToDocumentIdentifierValueConvertContext;
import org.hibernate.search.engine.backend.types.converter.spi.StringToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.search.common.ValueConvert;
import org.hibernate.search.engine.search.predicate.spi.MatchIdPredicateBuilder;

public class LuceneMatchIdPredicateBuilder
extends AbstractLuceneSearchPredicateBuilder
implements MatchIdPredicateBuilder<LuceneSearchPredicateBuilder> {
    private static final StringToDocumentIdentifierValueConverter RAW_CONVERTER = new StringToDocumentIdentifierValueConverter();
    private final List<String> values = new ArrayList<String>();
    private final LuceneSearchContext searchContext;
    private final LuceneCompatibilityChecker converterChecker;
    private final ToDocumentIdentifierValueConverter<?> converter;

    LuceneMatchIdPredicateBuilder(LuceneSearchContext searchContext, LuceneCompatibilityChecker converterChecker, ToDocumentIdentifierValueConverter<?> converter) {
        this.searchContext = searchContext;
        this.converterChecker = converterChecker;
        this.converter = converter;
    }

    public void value(Object value, ValueConvert valueConvert) {
        ToDocumentIdentifierValueConverter<?> dslToDocumentIdConverter = this.getDslToDocumentIdentifierConverter(valueConvert);
        ToDocumentIdentifierValueConvertContext toDocumentIdentifierValueConvertContext = this.searchContext.getToDocumentIdentifierValueConvertContext();
        this.values.add(dslToDocumentIdConverter.convertUnknown(value, toDocumentIdentifierValueConvertContext));
    }

    @Override
    public void checkNestableWithin(String expectedParentNestedPath) {
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        for (String value : this.values) {
            builder.add((Query)this.termQuery(value), BooleanClause.Occur.SHOULD);
        }
        return builder.build();
    }

    private TermQuery termQuery(String value) {
        return new TermQuery(new Term(MetadataFields.idFieldName(), value));
    }

    private ToDocumentIdentifierValueConverter<?> getDslToDocumentIdentifierConverter(ValueConvert convert) {
        switch (convert) {
            case NO: {
                return RAW_CONVERTER;
            }
        }
        this.converterChecker.failIfNotCompatible();
        return this.converter;
    }
}

