/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.query.dsl.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.backend.lucene.LuceneExtension;
import org.hibernate.search.backend.lucene.scope.impl.LuceneIndexScope;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchQueryElementCollector;
import org.hibernate.search.backend.lucene.search.predicate.dsl.LuceneSearchPredicateFactory;
import org.hibernate.search.backend.lucene.search.projection.dsl.LuceneSearchProjectionFactory;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryOptionsStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQuerySelectStep;
import org.hibernate.search.backend.lucene.search.query.dsl.LuceneSearchQueryWhereStep;
import org.hibernate.search.backend.lucene.search.query.dsl.impl.LuceneSearchQueryOptionsStepImpl;
import org.hibernate.search.backend.lucene.search.query.impl.LuceneSearchQueryBuilder;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.projection.dsl.ProjectionFinalStep;
import org.hibernate.search.engine.search.query.dsl.spi.AbstractSearchQuerySelectStep;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public class LuceneSearchQuerySelectStepImpl<R, E, LOS>
extends AbstractSearchQuerySelectStep<LuceneSearchQueryOptionsStep<E, LOS>, R, E, LOS, LuceneSearchProjectionFactory<R, E>, LuceneSearchPredicateFactory, LuceneSearchQueryElementCollector>
implements LuceneSearchQuerySelectStep<R, E, LOS> {
    private final LuceneIndexScope indexScope;
    private final BackendSessionContext sessionContext;
    private final LoadingContextBuilder<R, E, LOS> loadingContextBuilder;

    public LuceneSearchQuerySelectStepImpl(LuceneIndexScope indexScope, BackendSessionContext sessionContext, LoadingContextBuilder<R, E, LOS> loadingContextBuilder) {
        this.indexScope = indexScope;
        this.sessionContext = sessionContext;
        this.loadingContextBuilder = loadingContextBuilder;
    }

    @Override
    public LuceneSearchQueryWhereStep<E, LOS> selectEntity() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().selectEntity(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryWhereStep<R, LOS> selectEntityReference() {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().selectEntityReference(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public <P> LuceneSearchQueryWhereStep<P, LOS> select(Function<? super LuceneSearchProjectionFactory<R, E>, ? extends ProjectionFinalStep<P>> projectionContributor) {
        LuceneSearchProjectionFactory factoryContext = (LuceneSearchProjectionFactory)this.createDefaultProjectionFactory().extension(LuceneExtension.get());
        SearchProjection projection = projectionContributor.apply(factoryContext).toProjection();
        return this.select(projection);
    }

    @Override
    public <P> LuceneSearchQueryWhereStep<P, LOS> select(SearchProjection<P> projection) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().select(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection)projection);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    @Override
    public LuceneSearchQueryWhereStep<List<?>, LOS> select(SearchProjection<?> ... projections) {
        SearchQueryBuilder builder = this.indexScope.getSearchQueryBuilderFactory().select(this.sessionContext, (LoadingContextBuilder)this.loadingContextBuilder, (SearchProjection[])projections);
        return this.createSearchQueryContext((LuceneSearchQueryBuilder)builder);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> where(SearchPredicate predicate) {
        return (LuceneSearchQueryOptionsStep)this.selectEntity().where(predicate);
    }

    public LuceneSearchQueryOptionsStep<E, LOS> where(Function<? super LuceneSearchPredicateFactory, ? extends PredicateFinalStep> predicateContributor) {
        return (LuceneSearchQueryOptionsStep)this.selectEntity().where(predicateContributor);
    }

    protected LuceneIndexScope getIndexScope() {
        return this.indexScope;
    }

    protected BackendSessionContext getSessionContext() {
        return this.sessionContext;
    }

    protected LoadingContextBuilder<R, E, LOS> getLoadingContextBuilder() {
        return this.loadingContextBuilder;
    }

    private <H> LuceneSearchQueryWhereStep<H, LOS> createSearchQueryContext(LuceneSearchQueryBuilder<H> builder) {
        return new LuceneSearchQueryOptionsStepImpl<H, LOS>(this.indexScope, builder, this.loadingContextBuilder);
    }
}

