/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.timeout.impl;

import java.lang.invoke.MethodHandles;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.Counter;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.timeout.impl.LuceneCounterAdapter;
import org.hibernate.search.backend.lucene.search.timeout.spi.TimingSource;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class TimeoutManager {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final TimingSource timingSource;
    private final Query query;
    private final Long timeoutMs;
    private final Long timeoutValue;
    private final TimeUnit timeoutUnit;
    private final Type type;
    private Long start;
    boolean timedOut = false;

    public static TimeoutManager noTimeout(TimingSource timingSource, Query query) {
        return new TimeoutManager(timingSource, query, null, null, Type.NONE);
    }

    public static TimeoutManager softTimeout(TimingSource timingSource, Query query, long timeout, TimeUnit timeUnit) {
        return new TimeoutManager(timingSource, query, timeout, timeUnit, Type.LIMIT);
    }

    public static TimeoutManager hardTimeout(TimingSource timingSource, Query query, long timeout, TimeUnit timeUnit) {
        return new TimeoutManager(timingSource, query, timeout, timeUnit, Type.EXCEPTION);
    }

    private TimeoutManager(TimingSource timingSource, Query query, Long timeoutValue, TimeUnit timeoutUnit, Type type) {
        this.timingSource = timingSource;
        this.query = query;
        this.timeoutValue = timeoutValue;
        this.timeoutUnit = timeoutUnit;
        this.timeoutMs = timeoutUnit == null ? null : Long.valueOf(timeoutUnit.toMillis(timeoutValue));
        this.type = type;
        timingSource.ensureInitialized();
    }

    public void start() {
        this.start = this.timingSource.getMonotonicTimeEstimate();
    }

    public void stop() {
        this.start = null;
    }

    public long getTimeoutBaseline() {
        return this.start;
    }

    public Long checkTimeLeftInMilliseconds() {
        if (this.timeoutMs == null) {
            return null;
        }
        long elapsedTime = this.getElapsedTimeInMilliseconds();
        long timeLeft = this.timeoutMs - elapsedTime;
        if (timeLeft <= 0L) {
            this.forceTimedOut();
            return 0L;
        }
        return timeLeft;
    }

    public Counter createCounter() {
        return new LuceneCounterAdapter(this.timingSource);
    }

    public boolean isTimedOut() {
        return this.timedOut;
    }

    public boolean checkTimedOut() {
        Long timeLeft = this.checkTimeLeftInMilliseconds();
        return timeLeft != null && timeLeft <= 0L;
    }

    public void forceTimedOut() {
        this.timedOut = Boolean.TRUE;
        this.onTimedOut();
    }

    private void onTimedOut() {
        if (this.hasHardTimeout()) {
            throw log.timedOut(Duration.ofNanos(this.timeoutUnit.toNanos(this.timeoutValue)), this.query.toString());
        }
    }

    public boolean hasHardTimeout() {
        return this.type == Type.EXCEPTION;
    }

    public Duration getTookTime() {
        return Duration.ofMillis(this.getElapsedTimeInMilliseconds());
    }

    private long getElapsedTimeInMilliseconds() {
        return this.timingSource.getMonotonicTimeEstimate() - this.start;
    }

    private static enum Type {
        NONE,
        EXCEPTION,
        LIMIT;

    }
}

