/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.aggregation.impl;

import java.io.IOException;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import org.apache.lucene.facet.FacetResult;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedNumericDocValues;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.types.aggregation.impl.AbstractLuceneFacetsBasedTermsAggregation;
import org.hibernate.search.backend.lucene.types.codec.impl.AbstractLuceneNumericFieldCodec;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class LuceneNumericTermsAggregation<F, E extends Number, K>
extends AbstractLuceneFacetsBasedTermsAggregation<F, E, K> {
    private final AbstractLuceneNumericFieldCodec<F, E> codec;
    private final LuceneNumericDomain<E> numericDomain;
    private final Comparator<E> termComparator;

    private LuceneNumericTermsAggregation(Builder<F, E, K> builder) {
        super(builder);
        this.codec = ((Builder)builder).codec;
        this.numericDomain = this.codec.getDomain();
        this.termComparator = this.numericDomain.createComparator();
    }

    @Override
    FacetResult getTopChildren(IndexReader reader, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider, int limit) throws IOException {
        Facets facetCounts = this.numericDomain.createTermsFacetCounts(this.absoluteFieldPath, facetsCollector, nestedDocsProvider);
        return facetCounts.getTopChildren(limit, this.absoluteFieldPath, new String[0]);
    }

    @Override
    SortedSet<E> collectFirstTerms(IndexReader reader, boolean descending, int limit) throws IOException {
        TreeSet<E> collectedTerms = new TreeSet<E>(descending ? this.termComparator.reversed() : this.termComparator);
        for (LeafReaderContext leaf : reader.leaves()) {
            LeafReader atomicReader = leaf.reader();
            SortedNumericDocValues docValues = atomicReader.getSortedNumericDocValues(this.absoluteFieldPath);
            if (docValues == null) continue;
            while (docValues.nextDoc() != Integer.MAX_VALUE) {
                for (int i = 0; i < docValues.docValueCount(); ++i) {
                    E term = this.numericDomain.sortedDocValueToTerm(docValues.nextValue());
                    collectedTerms.add(term);
                    if (collectedTerms.size() <= limit) continue;
                    collectedTerms.remove(collectedTerms.last());
                }
            }
        }
        return collectedTerms;
    }

    @Override
    Comparator<E> getAscendingTermComparator() {
        return this.termComparator;
    }

    @Override
    E labelToTerm(String termAsString) {
        return this.numericDomain.sortedDocValueToTerm(Long.parseLong(termAsString));
    }

    @Override
    F termToFieldValue(E term) {
        return this.codec.decode(term);
    }

    public static class Builder<F, E extends Number, K>
    extends AbstractLuceneFacetsBasedTermsAggregation.AbstractBuilder<F, E, K> {
        private final AbstractLuceneNumericFieldCodec<F, E> codec;

        public Builder(LuceneSearchContext searchContext, String nestedDocumentPath, String absoluteFieldPath, ProjectionConverter<? super F, ? extends K> fromFieldValueConverter, AbstractLuceneNumericFieldCodec<F, E> codec) {
            super(searchContext, nestedDocumentPath, absoluteFieldPath, fromFieldValueConverter);
            this.codec = codec;
        }

        @Override
        public LuceneNumericTermsAggregation<F, E, K> build() {
            return new LuceneNumericTermsAggregation(this);
        }
    }
}

