/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.dsl.impl;

import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneNativeFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldFieldCodec;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldContributor;
import org.hibernate.search.backend.lucene.types.converter.LuceneFieldValueExtractor;
import org.hibernate.search.backend.lucene.types.dsl.impl.AbstractLuceneIndexFieldTypeOptionsStep;
import org.hibernate.search.backend.lucene.types.impl.LuceneIndexFieldType;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneNativeFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneStandardFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneNativeFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

class LuceneNativeIndexFieldTypeOptionsStep<F>
extends AbstractLuceneIndexFieldTypeOptionsStep<LuceneNativeIndexFieldTypeOptionsStep<F>, F> {
    private final LuceneFieldContributor<F> fieldContributor;
    private final LuceneFieldValueExtractor<F> fieldValueExtractor;

    LuceneNativeIndexFieldTypeOptionsStep(Class<F> fieldType, LuceneFieldContributor<F> fieldContributor, LuceneFieldValueExtractor<F> fieldValueExtractor) {
        super(fieldType);
        this.fieldContributor = fieldContributor;
        this.fieldValueExtractor = fieldValueExtractor;
    }

    public IndexFieldType<F> toIndexFieldType() {
        DslConverter dslConverter = this.createDslConverter();
        ProjectionConverter projectionConverter = this.createProjectionConverter();
        ProjectionConverter rawProjectionConverter = this.createRawProjectionConverter();
        LuceneFieldFieldCodec<F> codec = new LuceneFieldFieldCodec<F>(this.fieldContributor, this.fieldValueExtractor);
        return new LuceneIndexFieldType(this.getFieldType(), dslConverter, projectionConverter, codec, LuceneNativeFieldPredicateBuilderFactory.INSTANCE, LuceneNativeFieldSortBuilderFactory.INSTANCE, new LuceneStandardFieldProjectionBuilderFactory(this.fieldValueExtractor != null, projectionConverter, rawProjectionConverter, codec), LuceneNativeFieldAggregationBuilderFactory.INSTANCE);
    }

    @Override
    protected LuceneNativeIndexFieldTypeOptionsStep<F> thisAsS() {
        return this;
    }
}

