/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.impl;

import java.util.Optional;
import org.apache.lucene.analysis.Analyzer;
import org.hibernate.search.backend.lucene.types.aggregation.impl.LuceneFieldAggregationBuilderFactory;
import org.hibernate.search.backend.lucene.types.codec.impl.LuceneFieldCodec;
import org.hibernate.search.backend.lucene.types.predicate.impl.LuceneFieldPredicateBuilderFactory;
import org.hibernate.search.backend.lucene.types.projection.impl.LuceneFieldProjectionBuilderFactory;
import org.hibernate.search.backend.lucene.types.sort.impl.LuceneFieldSortBuilderFactory;
import org.hibernate.search.engine.backend.metamodel.IndexValueFieldTypeDescriptor;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.converter.spi.DslConverter;
import org.hibernate.search.engine.backend.types.converter.spi.ProjectionConverter;

public class LuceneIndexFieldType<F>
implements IndexValueFieldTypeDescriptor,
IndexFieldType<F> {
    private final Class<F> valueType;
    private final DslConverter<?, ? extends F> dslConverter;
    private final ProjectionConverter<? super F, ?> projectionConverter;
    private final LuceneFieldCodec<F> codec;
    private final LuceneFieldPredicateBuilderFactory predicateBuilderFactory;
    private final LuceneFieldSortBuilderFactory sortBuilderFactory;
    private final LuceneFieldProjectionBuilderFactory projectionBuilderFactory;
    private final LuceneFieldAggregationBuilderFactory aggregationBuilderFactory;
    private final Analyzer indexingAnalyzerOrNormalizer;
    private final Analyzer searchAnalyzerOrNormalizer;
    private final String analyzerName;
    private final String searchAnalyzerName;
    private final String normalizerName;

    public LuceneIndexFieldType(Class<F> valueType, DslConverter<?, ? extends F> dslConverter, ProjectionConverter<? super F, ?> projectionConverter, LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory, LuceneFieldAggregationBuilderFactory aggregationBuilderFactory) {
        this(valueType, dslConverter, projectionConverter, codec, predicateBuilderFactory, sortBuilderFactory, projectionBuilderFactory, aggregationBuilderFactory, null, null, null, null, null);
    }

    public LuceneIndexFieldType(Class<F> valueType, DslConverter<?, ? extends F> dslConverter, ProjectionConverter<? super F, ?> projectionConverter, LuceneFieldCodec<F> codec, LuceneFieldPredicateBuilderFactory predicateBuilderFactory, LuceneFieldSortBuilderFactory sortBuilderFactory, LuceneFieldProjectionBuilderFactory projectionBuilderFactory, LuceneFieldAggregationBuilderFactory aggregationBuilderFactory, Analyzer indexingAnalyzerOrNormalizer, Analyzer searchAnalyzerOrNormalizer, String analyzerName, String searchAnalyzerName, String normalizerName) {
        this.valueType = valueType;
        this.dslConverter = dslConverter;
        this.projectionConverter = projectionConverter;
        this.codec = codec;
        this.predicateBuilderFactory = predicateBuilderFactory;
        this.sortBuilderFactory = sortBuilderFactory;
        this.projectionBuilderFactory = projectionBuilderFactory;
        this.aggregationBuilderFactory = aggregationBuilderFactory;
        this.indexingAnalyzerOrNormalizer = indexingAnalyzerOrNormalizer;
        this.searchAnalyzerOrNormalizer = searchAnalyzerOrNormalizer;
        this.analyzerName = analyzerName;
        this.searchAnalyzerName = searchAnalyzerName;
        this.normalizerName = normalizerName;
    }

    public String toString() {
        return "LuceneIndexFieldType[codec=" + this.codec + ", analyzerName=" + this.analyzerName + ", searchAnalyzerName=" + this.searchAnalyzerName + ", normalizerName=" + this.normalizerName + "]";
    }

    public boolean isSearchable() {
        return this.predicateBuilderFactory.isSearchable();
    }

    public boolean isSortable() {
        return this.sortBuilderFactory.isSortable();
    }

    public boolean isProjectable() {
        return this.projectionBuilderFactory.isProjectable();
    }

    public boolean isAggregable() {
        return this.aggregationBuilderFactory.isAggregable();
    }

    public Class<?> dslArgumentClass() {
        return this.dslConverter.getValueType();
    }

    public Class<?> projectedValueClass() {
        return this.projectionConverter.getValueType();
    }

    public Class<?> valueClass() {
        return this.valueType;
    }

    public Optional<String> analyzerName() {
        return Optional.ofNullable(this.analyzerName);
    }

    public Optional<String> normalizerName() {
        return Optional.ofNullable(this.normalizerName);
    }

    public Optional<String> searchAnalyzerName() {
        return Optional.ofNullable(this.searchAnalyzerName);
    }

    public Class<F> getValueType() {
        return this.valueType;
    }

    public LuceneFieldCodec<F> getCodec() {
        return this.codec;
    }

    public LuceneFieldPredicateBuilderFactory getPredicateBuilderFactory() {
        return this.predicateBuilderFactory;
    }

    public LuceneFieldSortBuilderFactory getSortBuilderFactory() {
        return this.sortBuilderFactory;
    }

    public LuceneFieldProjectionBuilderFactory getProjectionBuilderFactory() {
        return this.projectionBuilderFactory;
    }

    public LuceneFieldAggregationBuilderFactory getAggregationBuilderFactory() {
        return this.aggregationBuilderFactory;
    }

    public Analyzer getIndexingAnalyzerOrNormalizer() {
        return this.indexingAnalyzerOrNormalizer;
    }

    public Analyzer getSearchAnalyzerOrNormalizer() {
        return this.searchAnalyzerOrNormalizer;
    }
}

