/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.predicate.impl;

import java.util.List;
import org.apache.lucene.document.LatLonPoint;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.search.predicate.impl.AbstractLuceneSpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.engine.spatial.GeoPoint;

class LuceneGeoPointSpatialWithinPolygonPredicateBuilder
extends AbstractLuceneSpatialWithinPolygonPredicateBuilder {
    LuceneGeoPointSpatialWithinPolygonPredicateBuilder(String absoluteFieldPath, List<String> nestedPathHierarchy) {
        super(absoluteFieldPath, nestedPathHierarchy);
    }

    @Override
    protected Query doBuild(LuceneSearchPredicateContext context) {
        List points = this.polygon.getPoints();
        double[] polyLats = new double[points.size()];
        double[] polyLons = new double[points.size()];
        for (int i = 0; i < points.size(); ++i) {
            polyLats[i] = ((GeoPoint)points.get(i)).getLatitude();
            polyLons[i] = ((GeoPoint)points.get(i)).getLongitude();
        }
        Polygon lucenePolygon = new Polygon(polyLats, polyLons, new Polygon[0]);
        return LatLonPoint.newPolygonQuery((String)this.absoluteFieldPath, (Polygon[])new Polygon[]{lucenePolygon});
    }
}

