/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateBuilder;
import org.hibernate.search.backend.lucene.search.predicate.impl.LuceneSearchPredicateContext;
import org.hibernate.search.backend.lucene.search.sort.impl.AbstractLuceneSearchSortBuilder;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

public abstract class AbstractLuceneDocumentValueSortBuilder
extends AbstractLuceneSearchSortBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    protected final String absoluteFieldPath;
    protected final String nestedDocumentPath;
    private SortMode mode;
    private LuceneSearchPredicateBuilder filterBuilder;

    protected AbstractLuceneDocumentValueSortBuilder(String absoluteFieldPath, String nestedDocumentPath) {
        this.absoluteFieldPath = absoluteFieldPath;
        this.nestedDocumentPath = nestedDocumentPath;
    }

    public void mode(SortMode mode) {
        if (this.nestedDocumentPath != null && SortMode.MEDIAN.equals((Object)mode)) {
            throw log.cannotComputeMedianAcrossNested(this.getEventContext());
        }
        this.mode = mode;
    }

    public void filter(SearchPredicate filter) {
        if (this.nestedDocumentPath == null) {
            throw log.cannotFilterSortOnRootDocumentField(this.absoluteFieldPath, this.getEventContext());
        }
        LuceneSearchPredicateBuilder builder = (LuceneSearchPredicateBuilder)filter;
        builder.checkNestableWithin(this.nestedDocumentPath);
        this.filterBuilder = builder;
    }

    protected final MultiValueMode getMultiValueMode() {
        MultiValueMode multiValueMode;
        if (this.mode == null) {
            multiValueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
        } else {
            switch (this.mode) {
                case MIN: {
                    multiValueMode = MultiValueMode.MIN;
                    break;
                }
                case MAX: {
                    multiValueMode = MultiValueMode.MAX;
                    break;
                }
                case AVG: {
                    multiValueMode = MultiValueMode.AVG;
                    break;
                }
                case SUM: {
                    multiValueMode = MultiValueMode.SUM;
                    break;
                }
                case MEDIAN: {
                    multiValueMode = MultiValueMode.MEDIAN;
                    break;
                }
                default: {
                    throw new AssertionFailure("Unexpected sort mode: " + this.mode);
                }
            }
        }
        return multiValueMode;
    }

    protected Query getLuceneFilter() {
        if (this.filterBuilder == null) {
            return null;
        }
        LuceneSearchPredicateContext filterContext = new LuceneSearchPredicateContext(this.nestedDocumentPath);
        return this.filterBuilder.build(filterContext);
    }

    protected final EventContext getEventContext() {
        return EventContexts.fromIndexFieldAbsolutePath((String)this.absoluteFieldPath);
    }
}

