/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.sort.impl;

import java.lang.invoke.MethodHandles;
import org.apache.lucene.search.FieldComparatorSource;
import org.apache.lucene.search.SortField;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortBuilder;
import org.hibernate.search.backend.lucene.search.sort.impl.LuceneSearchSortCollector;
import org.hibernate.search.backend.lucene.types.sort.comparatorsource.impl.LuceneGeoPointDistanceComparatorSource;
import org.hibernate.search.backend.lucene.types.sort.impl.AbstractLuceneDocumentValueSortBuilder;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.sort.dsl.SortOrder;
import org.hibernate.search.engine.search.sort.spi.DistanceSortBuilder;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public class LuceneGeoPointDistanceSortBuilder
extends AbstractLuceneDocumentValueSortBuilder
implements DistanceSortBuilder<LuceneSearchSortBuilder> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final GeoPoint location;

    LuceneGeoPointDistanceSortBuilder(String absoluteFieldPath, String nestedDocumentPath, GeoPoint location) {
        super(absoluteFieldPath, nestedDocumentPath);
        this.location = location;
    }

    @Override
    public void mode(SortMode mode) {
        switch (mode) {
            case MIN: 
            case MAX: 
            case AVG: 
            case MEDIAN: {
                super.mode(mode);
                break;
            }
            default: {
                throw log.cannotComputeSumForDistanceSort(this.getEventContext());
            }
        }
    }

    @Override
    public void buildAndContribute(LuceneSearchSortCollector collector) {
        LuceneGeoPointDistanceComparatorSource fieldComparatorSource = new LuceneGeoPointDistanceComparatorSource(this.nestedDocumentPath, this.location, this.getMultiValueMode(), this.getLuceneFilter());
        SortField sortField = new SortField(this.absoluteFieldPath, (FieldComparatorSource)fieldComparatorSource, this.order == SortOrder.DESC);
        collector.collectSortField(sortField, this.nestedDocumentPath == null ? null : fieldComparatorSource);
    }
}

