/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.work.execution.impl;

import java.util.concurrent.CompletableFuture;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntry;
import org.hibernate.search.backend.lucene.document.impl.LuceneIndexEntryFactory;
import org.hibernate.search.backend.lucene.orchestration.impl.LuceneSerialWorkOrchestrator;
import org.hibernate.search.backend.lucene.work.execution.impl.WorkExecutionIndexManagerContext;
import org.hibernate.search.backend.lucene.work.impl.LuceneWorkFactory;
import org.hibernate.search.engine.backend.session.spi.BackendSessionContext;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentContributor;
import org.hibernate.search.engine.backend.work.execution.spi.DocumentReferenceProvider;
import org.hibernate.search.engine.backend.work.execution.spi.IndexIndexer;

public class LuceneIndexIndexer
implements IndexIndexer {
    private final LuceneWorkFactory factory;
    private final LuceneIndexEntryFactory indexEntryFactory;
    private final WorkExecutionIndexManagerContext indexManagerContext;
    private final String tenantId;

    public LuceneIndexIndexer(LuceneWorkFactory factory, LuceneIndexEntryFactory indexEntryFactory, WorkExecutionIndexManagerContext indexManagerContext, BackendSessionContext sessionContext) {
        this.factory = factory;
        this.indexEntryFactory = indexEntryFactory;
        this.indexManagerContext = indexManagerContext;
        this.tenantId = sessionContext.getTenantIdentifier();
    }

    public CompletableFuture<?> add(DocumentReferenceProvider referenceProvider, DocumentContributor documentContributor) {
        String id = referenceProvider.getIdentifier();
        String routingKey = referenceProvider.getRoutingKey();
        LuceneIndexEntry indexEntry = this.indexEntryFactory.create(this.tenantId, id, routingKey, documentContributor);
        LuceneSerialWorkOrchestrator orchestrator = this.indexManagerContext.getIndexingOrchestrator(id, routingKey);
        CompletableFuture future = new CompletableFuture();
        orchestrator.submit(future, this.factory.add(this.tenantId, this.indexManagerContext.getMappedTypeName(), referenceProvider.getEntityIdentifier(), id, indexEntry));
        return future;
    }
}

