/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.logging.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.util.Version;
import org.hibernate.search.backend.lucene.index.LuceneIndexManager;
import org.hibernate.search.engine.backend.scope.spi.IndexScopeBuilder;
import org.hibernate.search.engine.backend.types.converter.spi.ToDocumentIdentifierValueConverter;
import org.hibernate.search.engine.logging.spi.AggregationKeyFormatter;
import org.hibernate.search.engine.search.aggregation.AggregationKey;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.common.SortMode;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.engine.search.sort.SearchSort;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.logging.impl.EventContextFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.FormatWith;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.logging.annotations.Param;
import org.jboss.logging.annotations.ValidIdRange;
import org.jboss.logging.annotations.ValidIdRanges;

@MessageLogger(projectCode="HSEARCH")
@ValidIdRanges(value={@ValidIdRange(min=600000, max=609999), @ValidIdRange(min=35, max=35), @ValidIdRange(min=41, max=41), @ValidIdRange(min=52, max=52), @ValidIdRange(min=55, max=55), @ValidIdRange(min=75, max=75), @ValidIdRange(min=114, max=114), @ValidIdRange(min=118, max=118), @ValidIdRange(min=225, max=225), @ValidIdRange(min=226, max=226), @ValidIdRange(min=228, max=228), @ValidIdRange(min=265, max=265), @ValidIdRange(min=274, max=274), @ValidIdRange(min=284, max=284), @ValidIdRange(min=320, max=320), @ValidIdRange(min=321, max=321), @ValidIdRange(min=329, max=329), @ValidIdRange(min=330, max=330), @ValidIdRange(min=337, max=337), @ValidIdRange(min=341, max=341), @ValidIdRange(min=342, max=342), @ValidIdRange(min=344, max=344), @ValidIdRange(min=345, max=345), @ValidIdRange(min=353, max=353)})
public interface Log
extends BasicLogger {
    public static final int ID_OFFSET_LEGACY_ENGINE = 0;
    public static final int ID_OFFSET = 600000;

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=41, value="Index directory does not exist, creating: '%1$s'")
    public void indexDirectoryNotFoundCreatingNewOne(Path var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=52, value="An index writer operation failed. Resetting the index writer and forcing release of locks. %1$s")
    public void indexWriterResetAfterFailure(@FormatWith(value=EventContextFormatter.class) EventContext var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=55, value="Unable to close the index reader. %1$s")
    public void unableToCloseIndexReader(@FormatWith(value=EventContextFormatter.class) EventContext var1, @Cause Exception var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="Missing value for configuration property '%1$s': using LATEST (currently '%2$s'). %3$s")
    public void recommendConfiguringLuceneVersion(String var1, Version var2, @FormatWith(value=EventContextFormatter.class) EventContext var3);

    @Message(id=114, value="Resource does not exist in classpath: '%1$s'")
    public SearchException unableToLoadResource(String var1);

    @Message(value="Index Merge operation on index '%1$s'")
    public String indexMergeOperation(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=225, value="Unable to acquire lock on the index while initializing directory '%s'. Either the directory wasn't properly closed last time it was used due to a critical failure, or another instance of Hibernate Search is using it concurrently (which is not supported). If you experience indexing failures on this index you will need to remove the lock, and might need to rebuild the index.")
    public void lockingFailureDuringInitialization(String var1, @Param EventContext var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.TRACE)
    @Message(id=226, value="%s: %s")
    public void logInfoStreamMessage(String var1, String var2);

    @Message(id=228, value="Unable to parse '%1$ss' into a Lucene version: %2$s")
    public SearchException illegalLuceneVersionFormat(String var1, String var2, @Cause Exception var3);

    @LogMessage(level=Logger.Level.DEBUG)
    @Message(id=274, value="Executing Lucene query: %s")
    public void executingLuceneQuery(Query var1);

    @Message(id=284, value="Unable to open index readers: %1$s")
    public SearchException unableToOpenIndexReaders(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=329, value="Unable to apply analysis configuration: %1$s")
    public SearchException unableToApplyAnalysisConfiguration(String var1, @Cause Exception var2);

    @Message(id=337, value="Ambiguous value for parameter '%1$s': this parameter is set to two different values '%2$s' and '%3$s'.")
    public SearchException analysisComponentParameterConflict(String var1, String var2, String var3);

    @Message(id=342, value="Invalid index field type: both analyzer '%1$s' and normalizer '%2$s' are assigned to this type. Either an analyzer or a normalizer can be assigned, but not both.")
    public SearchException cannotApplyAnalyzerAndNormalizer(String var1, String var2, @Param EventContext var3);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=344, value="Invalid normalizer implementation: the normalizer for definition '%s' produced %d tokens. Normalizers should never produce more than one token. The tokens have been concatenated by Hibernate Search, but you should fix your normalizer definition.")
    public void normalizerProducedMultipleTokens(String var1, int var2);

    @Message(id=345, value="Invalid index field type: both analyzer '%1$s' and sorts are enabled. Sorts are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not sortable, and one with a normalizer that is sortable.")
    public SearchException cannotUseAnalyzerOnSortableField(String var1, @Param EventContext var2);

    @Message(id=353, value="Unknown analyzer: '%1$s'. Make sure you defined this analyzer.")
    public SearchException unknownAnalyzer(String var1, @Param EventContext var2);

    @Message(id=600000, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForSearch(String var1, @Param EventContext var2);

    @Message(id=600001, value="Path '%1$s' exists but does not point to a writable directory.")
    public SearchException pathIsNotWriteableDirectory(Path var1);

    @Message(id=600005, value="Invalid target for Lucene extension: '%1$s'. This extension can only be applied to components created by a Lucene backend.")
    public SearchException luceneExtensionOnUnknownType(Object var1);

    @Message(id=600010, value="Invalid search predicate: '%1$s'. You must build the predicate from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherPredicates(SearchPredicate var1);

    @Message(id=600013, value="Invalid target field: object field '%1$s' is flattened. If you want to use a 'nested' predicate on this field, set its structure to 'NESTED'. Do not forget to reindex all your data after changing the structure.")
    public SearchException nonNestedFieldForNestedQuery(String var1, @Param EventContext var2);

    @Message(id=600014, value="Invalid search sort: '%1$s'. You must build the sort from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchSortWithOtherSorts(SearchSort var1);

    @Message(id=600015, value="Unable to initialize index directory: %1$s")
    public SearchException unableToInitializeIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600016, value="Unable to index entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s")
    public SearchException unableToIndexEntry(String var1, String var2, Object var3, String var4, @Param EventContext var5, @Cause Exception var6);

    @Message(id=600017, value="Unable to delete entity of type '%2$s' with identifier '%3$s' and tenant identifier '%1$s': %4$s")
    public SearchException unableToDeleteEntryFromIndex(String var1, String var2, Object var3, String var4, @Param EventContext var5, @Cause Exception var6);

    @Message(id=600019, value="Unable to commit: %1$s")
    public SearchException unableToCommitIndex(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600024, value="Invalid multi-index scope: a scope cannot span both a Lucene index and another type of index. Base scope: '%1$s', incompatible (Lucene) index: '%2$s'.")
    public SearchException cannotMixLuceneScopeWithOtherType(IndexScopeBuilder var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600025, value="Invalid multi-index scope: a scope cannot span multiple Lucene backends. Base scope: '%1$s', incompatible index (from another backend): '%2$s'.")
    public SearchException cannotMixLuceneScopeWithOtherBackend(IndexScopeBuilder var1, LuceneIndexManager var2, @Param EventContext var3);

    @Message(id=600027, value="Unable to execute search query '%1$s': %2$s")
    public SearchException ioExceptionOnQueryExecution(Query var1, String var2, @Param EventContext var3, @Cause IOException var4);

    @Message(id=600029, value="Invalid backend configuration: index '%1$s' requires multi-tenancy but no multi-tenancy strategy is set.")
    public SearchException multiTenancyRequiredButNotSupportedByBackend(String var1, @Param EventContext var2);

    @Message(id=600030, value="Invalid multi-tenancy strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidMultiTenancyStrategyName(String var1, List<String> var2);

    @Message(id=600031, value="Invalid tenant identifier: '%1$s'. The tenant identifier must be null, because multi-tenancy is disabled for this backend.")
    public SearchException tenantIdProvidedButMultiTenancyDisabled(String var1, @Param EventContext var2);

    @Message(id=600032, value="Missing tenant identifier. The tenant identifier must be non-null, because multi-tenancy is enabled for this backend.")
    public SearchException multiTenancyEnabledButNoTenantIdProvided(@Param EventContext var1);

    @Message(id=600033, value="Invalid requested type for this backend: '%1$s'. Lucene backends can only be unwrapped to '%2$s'.")
    public SearchException backendUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600034, value="Duplicate index field definition: '%1$s'. Index field names must be unique. Look for two property mappings with the same field name, or two indexed-embeddeds with prefixes that lead to conflicting index field names, or two custom bridges declaring index fields with the same name.")
    public SearchException indexSchemaNodeNameConflict(String var1, @Param EventContext var2);

    @Message(id=600039, value="Invalid field reference for this document element: this document element has path '%1$s', but the referenced field has a parent with path '%2$s'.")
    public SearchException invalidFieldForDocumentElement(String var1, String var2);

    @Message(id=600044, value="Computed minimum for minimumShouldMatch constraint is out of bounds: expected a number between '1' and '%1$s', got '%2$s'.")
    public SearchException minimumShouldMatchMinimumOutOfBounds(int var1, int var2);

    @Message(id=600045, value="Multiple conflicting minimumShouldMatch constraints for ceiling '%1$s'")
    public SearchException minimumShouldMatchConflictingConstraints(int var1);

    @Message(id=600049, value="Invalid field path; expected path '%1$s', got '%2$s'.")
    public SearchException invalidFieldPath(String var1, String var2);

    @Message(id=600050, value="Unable to convert DSL argument: %1$s")
    public SearchException cannotConvertDslParameter(String var1, @Cause Exception var2, @Param EventContext var3);

    @Message(id=600051, value="Invalid requested type for this index manager: '%1$s'. Lucene index managers can only be unwrapped to '%2$s'.")
    public SearchException indexManagerUnwrappingWithUnknownType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600052, value="Unable to create analyzer for name '%1$s': %2$s")
    public SearchException unableToCreateAnalyzer(String var1, String var2, @Cause Exception var3);

    @Message(id=600053, value="Unable to create normalizer for name '%1$s': %2$s")
    public SearchException unableToCreateNormalizer(String var1, String var2, @Cause Exception var3);

    @Message(id=600054, value="Unknown normalizer: '%1$s'. Make sure you defined this normalizer.")
    public SearchException unknownNormalizer(String var1, @Param EventContext var2);

    @Message(id=600055, value="Invalid search projection: '%1$s'. You must build the projection from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherProjections(SearchProjection<?> var1);

    @Message(id=600058, value="Inconsistent configuration for field '%1$s' in a search query across multiple indexes: %2$s")
    public SearchException inconsistentConfigurationForFieldForSearch(String var1, String var2, @Param EventContext var3, @Cause SearchException var4);

    @Message(id=600061, value="Unable to shut down index accessor: %1$s")
    public SearchException unableToShutdownIndexAccessor(String var1, @Cause Exception var2);

    @Message(id=600062, value="No built-in index field type for class: '%1$s'.")
    public SearchException cannotGuessFieldType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @Param EventContext var2);

    @Message(id=600067, value="Unable to delete all entries matching query '%1$s': %2$s")
    public SearchException unableToDeleteAllEntriesFromIndex(Query var1, String var2, @Param EventContext var3, @Cause Exception var4);

    @Message(id=600068, value="Inconsistent configuration for the identifier in a search query across multiple indexes: converter differs: '%1$s' vs. '%2$s'.")
    public SearchException inconsistentConfigurationForIdentifierForSearch(ToDocumentIdentifierValueConverter<?> var1, ToDocumentIdentifierValueConverter<?> var2, @Param EventContext var3);

    @Message(id=600069, value="Unable to explain search query: %1$s")
    public SearchException ioExceptionOnExplain(String var1, @Cause IOException var2);

    @Message(id=600070, value="Full-text features (analysis, fuzziness) are not supported for fields of this type.")
    public SearchException fullTextFeaturesNotSupportedByFieldType(@Param EventContext var1);

    @Message(id=600071, value="Incomplete field definition. You must call toReference() to complete the field definition.")
    public SearchException incompleteFieldDefinition(@Param EventContext var1);

    @Message(id=600072, value="Multiple calls to toReference() for the same field definition. You must call toReference() exactly once.")
    public SearchException cannotCreateReferenceMultipleTimes(@Param EventContext var1);

    @Message(id=600073, value="Invalid index field type: both null token '%2$s' ('indexNullAs') and analyzer '%1$s' are assigned to this type. 'indexNullAs' is not supported on analyzed fields.")
    public SearchException cannotUseIndexNullAsAndAnalyzer(String var1, String var2, @Param EventContext var3);

    @Message(id=600074, value="Multiple values assigned to field '%1$s': this field is single-valued. Declare the field as multi-valued in order to allow this.")
    public SearchException multipleValuesForSingleValuedField(String var1);

    @Message(id=600075, value="Invalid use of explain(Object id) on a query targeting multiple types. Use explain(String typeName, Object id) and pass one of %1$s as the type name.")
    public SearchException explainRequiresTypeName(Set<String> var1);

    @Message(id=600076, value="Invalid mapped type name: '%2$s'. This type is not among the mapped types targeted by this query: %1$s.")
    public SearchException explainRequiresTypeTargetedByQuery(Set<String> var1, String var2);

    @Message(id=600077, value="Invalid document identifier: '%2$s'. No such document for type '%1$s'.")
    public SearchException explainUnknownDocument(String var1, String var2);

    @Message(id=600078, value="Unable to merge index segments: %1$s")
    public SearchException unableToMergeSegments(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600079, value="Unable to close the index writer after write failures: %1$s")
    public SearchException unableToCloseIndexWriterAfterFailures(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600080, value="Invalid index field type: missing decimal scale. Define the decimal scale explicitly.")
    public SearchException nullDecimalScale(@Param EventContext var1);

    @Message(id=600081, value="Unable to encode value '%1$s': this field type only supports values ranging from '%2$s' to '%3$s'. If you want to encode values that are outside this range, change the decimal scale for this field. Do not forget to reindex all your data after changing the decimal scale.")
    public SearchException scaledNumberTooLarge(Number var1, Number var2, Number var3);

    @Message(id=600082, value="Invalid index field type: decimal scale '%1$s' is positive. The decimal scale of BigInteger fields must be zero or negative.")
    public SearchException invalidDecimalScale(Integer var1, @Param EventContext var2);

    @Message(id=600084, value="Invalid search predicate: '%1$s'. You must build the predicate from a scope targeting indexes %3$s, but the given predicate was built from a scope targeting indexes %2$s.")
    public SearchException predicateDefinedOnDifferentIndexes(SearchPredicate var1, Set<String> var2, Set<String> var3);

    @Message(id=600085, value="Invalid search sort: '%1$s'. You must build the sort from a scope targeting indexes %3$s, but the given sort was built from a scope targeting indexes %2$s.")
    public SearchException sortDefinedOnDifferentIndexes(SearchSort var1, Set<String> var2, Set<String> var3);

    @Message(id=600086, value="Invalid search projection: '%1$s'. You must build the projection from a scope targeting indexes %3$s, but the given projection was built from a scope targeting indexes %2$s.")
    public SearchException projectionDefinedOnDifferentIndexes(SearchProjection<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=600087, value="Invalid filesystem access strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidFileSystemAccessStrategyName(String var1, List<String> var2);

    @Message(id=600088, value="Invalid locking strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidLockingStrategyName(String var1, List<String> var2);

    @Message(id=600089, value="Incorrect sharding strategy implementation: strategy '%1$s' did not declare any shard identifiers during initialization. Declare shard identifiers using context.shardIdentifiers(...) or, if sharding is disabled, call context.disableSharding().")
    public SearchException missingShardIdentifiersAfterShardingStrategyInitialization(Object var1);

    @Message(id=600090, value="Invalid configuration for sharding strategy '%1$s': configuration property '%2$s' must be set.")
    public SearchException missingPropertyValueForShardingStrategy(String var1, String var2);

    @Message(id=600091, value="Invalid routing key: '%1$s'. Valid keys are: %2$s.")
    public SearchException invalidRoutingKeyForExplicitShardingStrategy(String var1, Collection<String> var2);

    @Message(id=600094, value="Invalid index field type: both analyzer '%1$s' and aggregations are enabled. Aggregations are not supported on analyzed fields. If you need an analyzer simply to transform the text (lowercasing, ...) without splitting it into tokens, use a normalizer instead. If you need an actual analyzer (with tokenization), define two separate fields: one with an analyzer that is not aggregable, and one with a normalizer that is aggregable.")
    public SearchException cannotUseAnalyzerOnAggregableField(String var1, @Param EventContext var2);

    @Message(id=600098, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a Lucene search scope.")
    public SearchException cannotMixLuceneSearchQueryWithOtherAggregations(SearchAggregation<?> var1);

    @Message(id=600099, value="Invalid search aggregation: '%1$s'. You must build the aggregation from a scope targeting indexes %3$s, but the given aggregation was built from a scope targeting indexes %2$s.")
    public SearchException aggregationDefinedOnDifferentIndexes(SearchAggregation<?> var1, Set<String> var2, Set<String> var3);

    @Message(id=600102, value="Duplicate aggregation definitions for key: '%1$s'")
    public SearchException duplicateAggregationKey(@FormatWith(value=AggregationKeyFormatter.class) AggregationKey<?> var1);

    @Message(id=600104, value="Invalid index field type: search analyzer '%1$s' is assigned to this type, but the indexing analyzer is missing. Assign an indexing analyzer and a search analyzer, or remove the search analyzer.")
    public SearchException searchAnalyzerWithoutAnalyzer(String var1, @Param EventContext var2);

    @Message(id=600106, value="This field is a value field in some indexes, but an object field in other indexes.")
    public SearchException conflictingFieldModel();

    @Message(id=600108, value="Invalid I/O strategy name: '%1$s'. Valid names are: %2$s.")
    public SearchException invalidIOStrategyName(String var1, List<String> var2);

    @Message(id=600109, value="Index does not exist for directory '%1$s'")
    public SearchException missingIndex(Directory var1, @Param EventContext var2);

    @Message(id=600110, value="Unable to validate index directory: %1$s")
    public SearchException unableToValidateIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600111, value="Unable to drop index directory: %1$s")
    public SearchException unableToDropIndexDirectory(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600113, value="Invalid target fields for simple-query-string predicate: fields [%1$s, %3$s] are in different nested documents [%2$s, %4$s]. All fields targeted by a simple-query-string predicate must be in the same document.")
    public SearchException simpleQueryStringSpanningMultipleNestedPaths(String var1, String var2, String var3, String var4);

    @Message(id=600114, value="Invalid sort mode: %1$s. This sort mode is not supported for fields in nested documents.")
    public SearchException invalidSortModeAcrossNested(SortMode var1, @Param EventContext var2);

    @Message(id=600115, value="Invalid sort mode: %1$s. This sort mode is not supported for String fields. Only MIN and MAX are supported.")
    public SearchException invalidSortModeForStringField(SortMode var1, @Param EventContext var2);

    @Message(id=600116, value="Invalid sort mode: %1$s. This sort mode is not supported for temporal fields. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForTemporalField(SortMode var1, @Param EventContext var2);

    @Message(id=600117, value="Invalid sort mode: %1$s. This sort mode is not supported for a distance sort. Only MIN, MAX, AVG and MEDIAN are supported.")
    public SearchException invalidSortModeForDistanceSort(SortMode var1, @Param EventContext var2);

    @Message(id=600118, value="A failure occurred during a low-level write operation and the index writer had to be reset. Some write operations may have been lost as a result. Failure: %1$s")
    public SearchException uncommittedOperationsBecauseOfFailure(String var1, @Param EventContext var2, @Cause Throwable var3);

    @Message(id=600120, value="Invalid sort filter: field '%1$s' is not contained in a nested object. Sort filters are only available if the field to sort on is contained in a nested object.")
    public SearchException cannotFilterSortOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=600121, value="Invalid search predicate: %1$s. This predicate targets fields %3$s, but only fields that are contained in the nested object with path '%2$s' are allowed here.")
    public SearchException invalidNestedObjectPathForPredicate(SearchPredicate var1, String var2, List<String> var3);

    @Message(id=600122, value="Invalid aggregation filter: field '%1$s' is not contained in a nested object. Aggregation filters are only available if the field to aggregate on is contained in a nested object.")
    public SearchException cannotFilterAggregationOnRootDocumentField(String var1, @Param EventContext var2);

    @Message(id=600123, value="Invalid value for IndexWriter setting '%1$s': '%2$s'. %3$s")
    public SearchException illegalIndexWriterSetting(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=600124, value="Invalid value for merge policy setting '%1$s': '%2$s'. %3$s")
    public SearchException illegalMergePolicySetting(String var1, Object var2, String var3, @Cause Exception var4);

    @Message(id=600125, value="Duplicate index field template definition: '%1$s'. Multiple bridges may be trying to access the same index field template,  or two indexed-embeddeds may have prefixes that lead to conflicting field names, or you may have declared multiple conflicting mappings. In any case, there is something wrong with your mapping and you should fix it.")
    public SearchException indexSchemaFieldTemplateNameConflict(String var1, @Param EventContext var2);

    @Message(id=600126, value="Invalid value type. This field's values are of type '%1$s', which is not assignable from '%2$s'.")
    public SearchException invalidFieldValueType(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2, @Param EventContext var3);

    @Message(id=600127, value="Unknown field '%1$s'.")
    public SearchException unknownFieldForIndexing(String var1, @Param EventContext var2);

    @Message(id=600128, value="Invalid type: the index root is not an object field.")
    public SearchException invalidIndexElementTypeRootIsNotObjectField();

    @Message(id=600129, value="Invalid type: '%1$s' is a value field, not an object field.")
    public SearchException invalidIndexElementTypeValueFieldIsNotObjectField(String var1);

    @Message(id=600130, value="Invalid type: '%1$s' is an object field, not a value field.")
    public SearchException invalidIndexElementTypeObjectFieldIsNotValueField(String var1);

    @Message(id=600131, value="Invalid cardinality for projection on field '%1$s': the projection is single-valued, but this field is multi-valued. Make sure to call '.multi()' when you create the projection.")
    public SearchException invalidSingleValuedProjectionOnMultiValuedField(String var1, @Param EventContext var2);

    @Message(id=600132, value="Cannot use '%2$s' on field '%1$s'. Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant). If it already is, then '%2$s' is not available for fields of this type.")
    public SearchException cannotUseQueryElementForField(String var1, String var2, @Param EventContext var3);

    @Message(id=600133, value="Inconsistent support for '%1$s': %2$s")
    public SearchException inconsistentSupportForQueryElement(String var1, String var2, @Cause SearchException var3);

    @Message(id=600134, value="Field attribute '%1$s' differs: '%2$s' vs. '%3$s'.")
    public SearchException differentFieldAttribute(String var1, Object var2, Object var3);

    @Message(id=600135, value="Implementation class differs: '%1$s' vs. '%2$s'.")
    public SearchException differentImplementationClassForQueryElement(@FormatWith(value=ClassFormatter.class) Class<?> var1, @FormatWith(value=ClassFormatter.class) Class<?> var2);

    @Message(id=600136, value="Field codec differs: '%1$s' vs. '%2$s'.")
    public SearchException differentFieldCodecForQueryElement(Object var1, Object var2);

    @Message(id=600137, value="'%1$s' can be used in some of the targeted indexes, but not all of them. Make sure the field is marked as searchable/sortable/projectable/aggregable (whichever is relevant) in all indexes, and that the field has the same type in all indexes.")
    public SearchException partialSupportForQueryElement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=600138, value="Using deprecated filesystem access strategy '%1$s', which will be removed in a future version of Lucene. %2$s")
    public void deprecatedFileSystemAccessStrategy(String var1, @FormatWith(value=EventContextFormatter.class) EventContext var2);

    @Message(id=600139, value="Cannot use '%2$s' on field '%1$s'. '%2$s' is not available for object fields.")
    public SearchException cannotUseQueryElementForObjectField(String var1, String var2, @Param EventContext var3);

    @Message(id=600140, value="Cannot use '%2$s' on field '%1$s': %3$s")
    public SearchException cannotUseQueryElementForObjectFieldBecauseCreationException(String var1, String var2, String var3, @Cause SearchException var4, @Param EventContext var5);

    @Message(id=600141, value="Unable to compute size of index: %1$s")
    public SearchException unableToComputeIndexSize(String var1, @Param EventContext var2, @Cause Exception var3);

    @Message(id=600142, value="Unable to create instance of analysis component '%1$s': %2$s")
    public SearchException unableToCreateAnalysisComponent(@FormatWith(value=ClassFormatter.class) Class<?> var1, String var2, @Cause Exception var3);
}

