/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.lowlevel.collector.impl;

import java.util.Set;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.lowlevel.reader.impl.IndexReaderMetadataResolver;

public final class CollectorExecutionContext {
    private final IndexReaderMetadataResolver metadataResolver;
    private final IndexSearcher indexSearcher;
    private final Query luceneQuery;
    private final int maxDocs;

    public CollectorExecutionContext(IndexReaderMetadataResolver metadataResolver, IndexSearcher indexSearcher, Query luceneQuery, int maxDocs) {
        this.metadataResolver = metadataResolver;
        this.indexSearcher = indexSearcher;
        this.luceneQuery = luceneQuery;
        this.maxDocs = maxDocs;
    }

    public IndexReaderMetadataResolver getMetadataResolver() {
        return this.metadataResolver;
    }

    public IndexSearcher getIndexSearcher() {
        return this.indexSearcher;
    }

    public NestedDocsProvider createNestedDocsProvider(String nestedDocumentPath) {
        return new NestedDocsProvider(nestedDocumentPath, this.luceneQuery);
    }

    public NestedDocsProvider createNestedDocsProvider(Set<String> nestedDocumentPaths) {
        return new NestedDocsProvider(nestedDocumentPaths, this.luceneQuery);
    }

    public int getMaxDocs() {
        return this.maxDocs;
    }
}

