/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.types.lowlevel.impl;

import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.facet.Facets;
import org.apache.lucene.facet.FacetsCollector;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.DoubleValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.NumericUtils;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.DoubleMultiValuesToSingleValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.JoiningLongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.LongMultiValuesSource;
import org.hibernate.search.backend.lucene.lowlevel.docvalues.impl.MultiValueMode;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.FacetCountsUtils;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.LongMultiValueFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.facet.impl.LongMultiValueRangeFacetCounts;
import org.hibernate.search.backend.lucene.lowlevel.join.impl.NestedDocsProvider;
import org.hibernate.search.backend.lucene.types.lowlevel.impl.LuceneNumericDomain;
import org.hibernate.search.util.common.data.Range;

public class LuceneFloatDomain
implements LuceneNumericDomain<Float> {
    private static final LuceneNumericDomain<Float> INSTANCE = new LuceneFloatDomain();

    public static LuceneNumericDomain<Float> get() {
        return INSTANCE;
    }

    @Override
    public Float getMinValue() {
        return Float.valueOf(-3.4028235E38f);
    }

    @Override
    public Float getMaxValue() {
        return Float.valueOf(Float.MAX_VALUE);
    }

    @Override
    public Float getPreviousValue(Float value) {
        return Float.valueOf(Math.nextDown(value.floatValue()));
    }

    @Override
    public Float getNextValue(Float value) {
        return Float.valueOf(Math.nextUp(value.floatValue()));
    }

    @Override
    public Comparator<Float> createComparator() {
        return Comparator.naturalOrder();
    }

    @Override
    public Query createExactQuery(String absoluteFieldPath, Float value) {
        return FloatPoint.newExactQuery((String)absoluteFieldPath, (float)value.floatValue());
    }

    @Override
    public Query createRangeQuery(String absoluteFieldPath, Float lowerLimit, Float upperLimit) {
        return FloatPoint.newRangeQuery((String)absoluteFieldPath, (float)lowerLimit.floatValue(), (float)upperLimit.floatValue());
    }

    @Override
    public Float sortedDocValueToTerm(long longValue) {
        return Float.valueOf(NumericUtils.sortableIntToFloat((int)((int)longValue)));
    }

    @Override
    public Facets createTermsFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, NestedDocsProvider nestedDocsProvider) throws IOException {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromIntField(absoluteFieldPath, nestedDocsProvider);
        return new LongMultiValueFacetCounts(absoluteFieldPath, source, facetsCollector);
    }

    @Override
    public Facets createRangeFacetCounts(String absoluteFieldPath, FacetsCollector facetsCollector, Collection<? extends Range<? extends Float>> ranges, NestedDocsProvider nestedDocsProvider) throws IOException {
        JoiningLongMultiValuesSource source = JoiningLongMultiValuesSource.fromIntField(absoluteFieldPath, nestedDocsProvider);
        return new LongMultiValueRangeFacetCounts(absoluteFieldPath, (LongMultiValuesSource)source, facetsCollector, FacetCountsUtils.createLongRangesForFloatingPointValues(ranges, value -> NumericUtils.floatToSortableInt((float)value.floatValue()), Float.valueOf(Float.NEGATIVE_INFINITY), Float.valueOf(Float.POSITIVE_INFINITY)));
    }

    @Override
    public IndexableField createIndexField(String absoluteFieldPath, Float numericValue) {
        return new FloatPoint(absoluteFieldPath, new float[]{numericValue.floatValue()});
    }

    @Override
    public IndexableField createSortedDocValuesField(String absoluteFieldPath, Float numericValue) {
        return new SortedNumericDocValuesField(absoluteFieldPath, (long)NumericUtils.floatToSortableInt((float)numericValue.floatValue()));
    }

    @Override
    public FieldComparator.NumericComparator<Float> createFieldComparator(String fieldname, int numHits, MultiValueMode multiValueMode, Float missingValue, NestedDocsProvider nestedDocsProvider) {
        DoubleMultiValuesToSingleValuesSource source = DoubleMultiValuesToSingleValuesSource.fromFloatField(fieldname, multiValueMode, nestedDocsProvider);
        return new FloatFieldComparator(numHits, fieldname, missingValue, source);
    }

    public static class FloatFieldComparator
    extends FieldComparator.FloatComparator {
        private final DoubleMultiValuesToSingleValuesSource source;

        public FloatFieldComparator(int numHits, String field, Float missingValue, DoubleMultiValuesToSingleValuesSource source) {
            super(numHits, field, missingValue);
            this.source = source;
        }

        protected NumericDocValues getNumericDocValues(LeafReaderContext context, String field) throws IOException {
            return this.source.getValues(context, DoubleValues.withDefault((DoubleValues)DoubleValues.EMPTY, (double)((Float)this.missingValue).floatValue())).getRawFloatValues();
        }
    }
}

