/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.analysis.model.dsl.impl;

import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.util.CharFilterFactory;
import org.apache.lucene.analysis.util.TokenFilterFactory;
import org.hibernate.search.backend.lucene.analysis.impl.LuceneAnalysisComponentFactory;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneAnalysisComponentParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.LuceneNormalizerOptionalComponentsStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalysisComponentBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneAnalyzerBuilder;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneCharFilterParametersStep;
import org.hibernate.search.backend.lucene.analysis.model.dsl.impl.LuceneTokenFilterParametersStep;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class LuceneNormalizerComponentsStep
implements LuceneNormalizerOptionalComponentsStep,
LuceneAnalyzerBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final String name;
    private final List<LuceneCharFilterParametersStep> charFilters = new ArrayList<LuceneCharFilterParametersStep>();
    private final List<LuceneTokenFilterParametersStep> tokenFilters = new ArrayList<LuceneTokenFilterParametersStep>();

    LuceneNormalizerComponentsStep(String name) {
        this.name = name;
    }

    @Override
    public LuceneAnalysisComponentParametersStep charFilter(Class<? extends CharFilterFactory> factory) {
        LuceneCharFilterParametersStep filter = new LuceneCharFilterParametersStep(this, factory);
        this.charFilters.add(filter);
        return filter;
    }

    @Override
    public LuceneAnalysisComponentParametersStep tokenFilter(Class<? extends TokenFilterFactory> factory) {
        LuceneTokenFilterParametersStep filter = new LuceneTokenFilterParametersStep(this, factory);
        this.tokenFilters.add(filter);
        return filter;
    }

    @Override
    public Analyzer build(LuceneAnalysisComponentFactory factory) {
        try {
            return factory.createNormalizer(this.name, (CharFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.charFilters, CharFilterFactory[]::new, factory), (TokenFilterFactory[])LuceneAnalysisComponentBuilder.buildAll(this.tokenFilters, TokenFilterFactory[]::new, factory));
        }
        catch (IOException | RuntimeException e) {
            throw log.unableToCreateNormalizer(this.name, e.getMessage(), e);
        }
    }
}

