/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.search.projection.impl;

import java.lang.invoke.MethodHandles;
import java.util.Set;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.search.extraction.impl.LuceneResult;
import org.hibernate.search.backend.lucene.search.impl.LuceneSearchContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionExtractContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionRequestContext;
import org.hibernate.search.backend.lucene.search.projection.impl.SearchProjectionTransformContext;
import org.hibernate.search.engine.search.loading.spi.LoadingResult;
import org.hibernate.search.engine.search.loading.spi.ProjectionHitMapper;
import org.hibernate.search.engine.search.projection.SearchProjection;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public interface LuceneSearchProjection<E, P>
extends SearchProjection<P> {
    public static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    public Set<String> indexNames();

    public void request(SearchProjectionRequestContext var1);

    public E extract(ProjectionHitMapper<?, ?> var1, LuceneResult var2, SearchProjectionExtractContext var3);

    public P transform(LoadingResult<?, ?> var1, E var2, SearchProjectionTransformContext var3);

    public static <P> LuceneSearchProjection<?, P> from(LuceneSearchContext searchContext, SearchProjection<P> projection) {
        if (!(projection instanceof LuceneSearchProjection)) {
            throw log.cannotMixLuceneSearchQueryWithOtherProjections(projection);
        }
        LuceneSearchProjection casted = (LuceneSearchProjection)projection;
        if (!searchContext.indexes().indexNames().equals(casted.indexNames())) {
            throw log.projectionDefinedOnDifferentIndexes(projection, casted.indexNames(), searchContext.indexes().indexNames());
        }
        return casted;
    }

    public static <Z> Z transformUnsafe(LuceneSearchProjection<?, Z> projection, LoadingResult<?, ?> loadingResult, Object extractedData, SearchProjectionTransformContext context) {
        return projection.transform(loadingResult, extractedData, context);
    }
}

