/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.backend.lucene.index.impl;

import java.lang.invoke.MethodHandles;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.hibernate.search.backend.lucene.document.model.impl.LuceneIndexModel;
import org.hibernate.search.backend.lucene.index.impl.IndexManagerBackendContext;
import org.hibernate.search.backend.lucene.index.impl.Shard;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategy;
import org.hibernate.search.backend.lucene.index.spi.ShardingStrategyInitializationContext;
import org.hibernate.search.backend.lucene.logging.impl.Log;
import org.hibernate.search.backend.lucene.lowlevel.directory.impl.DirectoryCreationContextImpl;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryHolder;
import org.hibernate.search.backend.lucene.lowlevel.directory.spi.DirectoryProvider;
import org.hibernate.search.backend.lucene.lowlevel.index.impl.IOStrategy;
import org.hibernate.search.engine.backend.index.spi.IndexManagerStartContext;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationProperty;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.reporting.spi.ContextualFailureCollector;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.util.common.impl.SuppressingCloser;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

class ShardingStrategyInitializationContextImpl
implements ShardingStrategyInitializationContext {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final ConfigurationProperty<BeanReference<? extends ShardingStrategy>> SHARDING_STRATEGY = ConfigurationProperty.forKey((String)"strategy").asBeanReference(ShardingStrategy.class).withDefault((Object)BeanReference.of(ShardingStrategy.class, (String)"none")).build();
    private static final ConfigurationProperty<BeanReference<? extends DirectoryProvider>> DIRECTORY_TYPE = ConfigurationProperty.forKey((String)"directory.type").asBeanReference(DirectoryProvider.class).withDefault((Object)BeanReference.of(DirectoryProvider.class, (String)"local-filesystem")).build();
    private final IndexManagerBackendContext backendContext;
    private final LuceneIndexModel model;
    private final IndexManagerStartContext startContext;
    private final ConfigurationPropertySource indexPropertySource;
    private final ConfigurationPropertySource shardingPropertySource;
    private Set<String> shardIdentifiers = new LinkedHashSet<String>();

    ShardingStrategyInitializationContextImpl(IndexManagerBackendContext backendContext, LuceneIndexModel model, IndexManagerStartContext startContext, ConfigurationPropertySource indexPropertySource) {
        this.backendContext = backendContext;
        this.model = model;
        this.startContext = startContext;
        this.indexPropertySource = indexPropertySource;
        this.shardingPropertySource = indexPropertySource.withMask("sharding");
    }

    @Override
    public void shardIdentifiers(Set<String> shardIdentifiers) {
        this.shardIdentifiers.clear();
        this.shardIdentifiers.addAll(shardIdentifiers);
    }

    @Override
    public void disableSharding() {
        this.shardIdentifiers = null;
    }

    @Override
    public String indexName() {
        return this.model.hibernateSearchName();
    }

    @Override
    public BeanResolver beanResolver() {
        return this.startContext.beanResolver();
    }

    @Override
    public ConfigurationPropertySource configurationPropertySource() {
        return this.shardingPropertySource;
    }

    public BeanHolder<? extends ShardingStrategy> create(Map<String, Shard> shardCollector) {
        BeanHolder shardingStrategyHolder = (BeanHolder)SHARDING_STRATEGY.getAndTransform(this.shardingPropertySource, arg_0 -> ((BeanResolver)this.beanResolver()).resolve(arg_0));
        ((ShardingStrategy)shardingStrategyHolder.get()).initialize(this);
        if (this.shardIdentifiers == null) {
            this.contributeShardWithSilentFailure(shardCollector, Optional.empty());
            return null;
        }
        if (this.shardIdentifiers.isEmpty()) {
            throw log.missingShardIdentifiersAfterShardingStrategyInitialization(shardingStrategyHolder.get());
        }
        for (String shardIdentifier : this.shardIdentifiers) {
            this.contributeShardWithSilentFailure(shardCollector, Optional.of(shardIdentifier));
        }
        return shardingStrategyHolder;
    }

    private void contributeShardWithSilentFailure(Map<String, Shard> shardCollector, Optional<String> shardId) {
        EventContext shardEventContext = EventContexts.fromIndexNameAndShardId((String)this.indexName(), shardId);
        ConfigurationPropertySource shardPropertySource = shardId.isPresent() ? this.indexPropertySource.withMask("shards").withMask(shardId.get()).withFallback(this.indexPropertySource) : this.indexPropertySource;
        DirectoryHolder directoryHolder = null;
        try (BeanHolder directoryProviderHolder = (BeanHolder)DIRECTORY_TYPE.getAndTransform(shardPropertySource, arg_0 -> ((BeanResolver)this.startContext.beanResolver()).resolve(arg_0));){
            DirectoryCreationContextImpl context = new DirectoryCreationContextImpl(shardEventContext, this.indexName(), shardId, this.beanResolver(), shardPropertySource.withMask("directory"));
            directoryHolder = ((DirectoryProvider)directoryProviderHolder.get()).createDirectoryHolder(context);
            IOStrategy ioStrategy = this.backendContext.createIOStrategy(shardPropertySource);
            Shard shard = this.backendContext.createShard(this.model, shardEventContext, directoryHolder, ioStrategy, shardPropertySource);
            shardCollector.put(shardId.orElse(null), shard);
        }
        catch (RuntimeException e) {
            new SuppressingCloser((Throwable)e).push(directoryHolder);
            ContextualFailureCollector failureCollector = this.startContext.failureCollector();
            if (shardId.isPresent()) {
                failureCollector = failureCollector.withContext(EventContexts.fromShardId((String)shardId.get()));
            }
            failureCollector.add((Throwable)e);
        }
    }
}

