/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.document.model.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.function.Function;
import org.hibernate.search.engine.backend.document.IndexFieldAccessor;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaElement;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaFieldTerminalContext;
import org.hibernate.search.engine.backend.document.model.dsl.IndexSchemaObjectField;
import org.hibernate.search.engine.backend.document.model.dsl.ObjectFieldStorage;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaNestingContext;
import org.hibernate.search.engine.backend.document.model.dsl.impl.IndexSchemaObjectFieldImpl;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectFieldNodeBuilder;
import org.hibernate.search.engine.backend.document.model.dsl.spi.IndexSchemaObjectNodeBuilder;
import org.hibernate.search.engine.backend.types.IndexFieldType;
import org.hibernate.search.engine.backend.types.dsl.IndexFieldTypeFactoryContext;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.StringHelper;

public class IndexSchemaElementImpl<B extends IndexSchemaObjectNodeBuilder>
implements IndexSchemaElement {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final IndexFieldTypeFactoryContext typeFactoryContext;
    final B objectNodeBuilder;
    private final IndexSchemaNestingContext nestingContext;

    public IndexSchemaElementImpl(IndexFieldTypeFactoryContext typeFactoryContext, B objectNodeBuilder, IndexSchemaNestingContext nestingContext) {
        this.typeFactoryContext = typeFactoryContext;
        this.objectNodeBuilder = objectNodeBuilder;
        this.nestingContext = nestingContext;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "objectNodeBuilder=" + this.objectNodeBuilder + ",nestingContext=" + this.nestingContext + "]";
    }

    @Override
    public <F> IndexSchemaFieldTerminalContext<IndexFieldAccessor<F>> field(String relativeFieldName, IndexFieldType<F> type) {
        this.checkRelativeFieldName(relativeFieldName);
        return this.nestingContext.nest(relativeFieldName, prefixedName -> this.objectNodeBuilder.addField((String)prefixedName, type), prefixedName -> this.objectNodeBuilder.createExcludedField((String)prefixedName, type));
    }

    @Override
    public <F> IndexSchemaFieldTerminalContext<IndexFieldAccessor<F>> field(String relativeFieldName, Function<IndexFieldTypeFactoryContext, IndexFieldType<F>> typeContributor) {
        return this.field(relativeFieldName, typeContributor.apply(this.typeFactoryContext));
    }

    @Override
    public IndexSchemaObjectField objectField(String relativeFieldName, ObjectFieldStorage storage) {
        this.checkRelativeFieldName(relativeFieldName);
        return this.nestingContext.nest(relativeFieldName, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.addObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactoryContext, objectFieldBuilder, (IndexSchemaNestingContext)filter);
        }, (prefixedName, filter) -> {
            IndexSchemaObjectFieldNodeBuilder objectFieldBuilder = this.objectNodeBuilder.createExcludedObjectField((String)prefixedName, storage);
            return new IndexSchemaObjectFieldImpl(this.typeFactoryContext, objectFieldBuilder, (IndexSchemaNestingContext)filter);
        });
    }

    private void checkRelativeFieldName(String relativeFieldName) {
        if (StringHelper.isEmpty((String)relativeFieldName)) {
            throw log.relativeFieldNameCannotBeNullOrEmpty(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
        if (relativeFieldName.contains(".")) {
            throw log.relativeFieldNameCannotContainDot(relativeFieldName, this.objectNodeBuilder.getEventContext());
        }
    }
}

