/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.backend.types.converter.spi;

import org.hibernate.search.engine.backend.types.converter.ToDocumentFieldValueConverter;
import org.hibernate.search.engine.backend.types.converter.runtime.ToDocumentFieldValueConvertContext;
import org.hibernate.search.util.impl.common.Contracts;

public final class PassThroughToDocumentFieldValueConverter<F>
implements ToDocumentFieldValueConverter<F, F> {
    private final Class<F> valueType;

    public PassThroughToDocumentFieldValueConverter(Class<F> valueType) {
        Contracts.assertNotNull(valueType, (String)"valueType");
        this.valueType = valueType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.valueType + "]";
    }

    @Override
    public F convert(F value, ToDocumentFieldValueConvertContext context) {
        return value;
    }

    @Override
    public F convertUnknown(Object value, ToDocumentFieldValueConvertContext context) {
        return this.valueType.cast(value);
    }

    @Override
    public boolean isCompatibleWith(ToDocumentFieldValueConverter<?, ?> other) {
        if (!this.getClass().equals(other.getClass())) {
            return false;
        }
        PassThroughToDocumentFieldValueConverter castedOther = (PassThroughToDocumentFieldValueConverter)other;
        return this.valueType.equals(castedOther.valueType);
    }
}

