/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchTarget;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.impl.DefaultSearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQueryResultContextImpl;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.spi.SearchTargetContext;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.engine.search.query.impl.DefaultProjectionHitMapper;
import org.hibernate.search.engine.search.query.impl.NoLoadingProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

class MappedIndexSearchTargetImpl<C, R, O>
implements MappedIndexSearchTarget<R, O> {
    private final SearchTargetContext<C> searchTargetContext;
    private final Function<DocumentReference, R> documentReferenceTransformer;

    MappedIndexSearchTargetImpl(SearchTargetContext<C> searchTargetContext, Function<DocumentReference, R> documentReferenceTransformer) {
        this.searchTargetContext = searchTargetContext;
        this.documentReferenceTransformer = documentReferenceTransformer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "context=" + this.searchTargetContext + "]";
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsLoadedObject(SessionContextImplementor sessionContext, ObjectLoader<R, T> objectLoader, Function<SearchQuery<T>, Q> searchQueryWrapperFactory) {
        DefaultProjectionHitMapper<R, T> projectionHitMapper = new DefaultProjectionHitMapper<R, T>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<T, C> builder = this.searchTargetContext.getSearchQueryBuilderFactory().asObject(sessionContext, projectionHitMapper);
        return new SearchQueryResultContextImpl<T, C, Q>(this.searchTargetContext, builder, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsReference(SessionContextImplementor sessionContext, Function<SearchQuery<R>, Q> searchQueryWrapperFactory) {
        NoLoadingProjectionHitMapper<R> referenceHitMapper = new NoLoadingProjectionHitMapper<R>(this.documentReferenceTransformer);
        SearchQueryBuilder builder = this.searchTargetContext.getSearchQueryBuilderFactory().asReference(sessionContext, referenceHitMapper);
        return new SearchQueryResultContextImpl(this.searchTargetContext, builder, searchQueryWrapperFactory);
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsProjection(SessionContextImplementor sessionContext, ObjectLoader<R, O> objectLoader, Function<SearchQuery<T>, Q> searchQueryWrapperFactory, SearchProjection<T> projection) {
        DefaultProjectionHitMapper<R, O> projectionHitMapper = new DefaultProjectionHitMapper<R, O>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<T, C> builder = this.searchTargetContext.getSearchQueryBuilderFactory().asProjection(sessionContext, projectionHitMapper, projection);
        return new SearchQueryResultContextImpl<T, C, Q>(this.searchTargetContext, builder, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsProjections(SessionContextImplementor sessionContext, ObjectLoader<R, O> objectLoader, Function<SearchQuery<List<?>>, Q> searchQueryWrapperFactory, SearchProjection<?> ... projections) {
        DefaultProjectionHitMapper<R, O> projectionHitMapper = new DefaultProjectionHitMapper<R, O>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<List<R>, C> builder = this.searchTargetContext.getSearchQueryBuilderFactory().asProjections(sessionContext, projectionHitMapper, projections);
        return new SearchQueryResultContextImpl(this.searchTargetContext, builder, searchQueryWrapperFactory);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return new DefaultSearchPredicateFactoryContext(this.searchTargetContext.getSearchPredicateBuilderFactory());
    }

    @Override
    public SearchSortContainerContext sort() {
        return new DefaultSearchSortContainerContext(this.searchTargetContext.getSearchSortBuilderFactory());
    }

    @Override
    public SearchProjectionFactoryContext<R, O> projection() {
        return new DefaultSearchProjectionFactoryContext(this.searchTargetContext.getSearchProjectionFactory());
    }
}

