/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.common.impl.IndexManagerBuildingStateHolder;
import org.hibernate.search.engine.common.impl.MappingBuildContextImpl;
import org.hibernate.search.engine.common.impl.RootBuildContext;
import org.hibernate.search.engine.common.impl.SearchIntegrationImpl;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationBuilder;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanProvider;
import org.hibernate.search.engine.environment.bean.spi.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.ReflectionBeanResolver;
import org.hibernate.search.engine.environment.classpath.spi.ClassResolver;
import org.hibernate.search.engine.environment.classpath.spi.DefaultClassAndResourceResolver;
import org.hibernate.search.engine.environment.classpath.spi.ResourceResolver;
import org.hibernate.search.engine.environment.service.impl.ServiceManagerImpl;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.logging.impl.RootFailureCollector;
import org.hibernate.search.engine.logging.spi.ContextualFailureCollector;
import org.hibernate.search.engine.logging.spi.EventContexts;
import org.hibernate.search.engine.mapper.mapping.building.spi.IndexManagerBuildingState;
import org.hibernate.search.engine.mapper.mapping.building.spi.Mapper;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingAbortedException;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingInitiator;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataContributorProvider;
import org.hibernate.search.engine.mapper.mapping.building.spi.TypeMetadataDiscoverer;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.util.AssertionFailure;
import org.hibernate.search.util.SearchException;
import org.hibernate.search.util.impl.common.LoggerFactory;
import org.hibernate.search.util.impl.common.SuppressingCloser;

public class SearchIntegrationBuilderImpl
implements SearchIntegrationBuilder {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private static final int FAILURE_LIMIT = 100;
    private final ConfigurationPropertySource mainPropertySource;
    private final Map<String, Object> overriddenProperties = new LinkedHashMap<String, Object>();
    private final Map<MappingKey<?>, MappingInitiator<?, ?>> mappingInitiators = new LinkedHashMap();
    private ClassResolver classResolver;
    private ResourceResolver resourceResolver;
    private BeanResolver beanResolver;
    private boolean frozen = false;

    public SearchIntegrationBuilderImpl(ConfigurationPropertySource mainPropertySource) {
        this.mainPropertySource = mainPropertySource;
    }

    @Override
    public SearchIntegrationBuilder setClassResolver(ClassResolver classResolver) {
        this.classResolver = classResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setResourceResolver(ResourceResolver resourceResolver) {
        this.resourceResolver = resourceResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setBeanResolver(BeanResolver beanResolver) {
        this.beanResolver = beanResolver;
        return this;
    }

    @Override
    public SearchIntegrationBuilder setProperty(String name, Object value) {
        this.overriddenProperties.put(name, value);
        return this;
    }

    @Override
    public <M> SearchIntegrationBuilder addMappingInitiator(MappingKey<M> mappingKey, MappingInitiator<?, M> initiator) {
        if (this.frozen) {
            throw new AssertionFailure("Attempt to add a mapping initiator after Hibernate Search has started to build the mappings. There is a bug in the Hibernate Search integration.");
        }
        MappingInitiator<?, M> existing = this.mappingInitiators.putIfAbsent(mappingKey, initiator);
        if (existing != null) {
            throw new AssertionFailure("Mapping key '" + mappingKey + "' has multiple initiators: '" + existing + "', '" + initiator + "'. There is a bug in the mapper, please report it.");
        }
        return this;
    }

    @Override
    public SearchIntegration build() {
        IndexManagerBuildingStateHolder indexManagerBuildingStateHolder = null;
        ArrayList mappingBuildingStates = new ArrayList();
        HashMap mappings = new HashMap();
        RootFailureCollector failureCollector = new RootFailureCollector(100);
        boolean checkingRootFailures = false;
        try {
            this.frozen = true;
            DefaultClassAndResourceResolver defaultClassAndResourceResolver = null;
            if (this.classResolver == null) {
                defaultClassAndResourceResolver = new DefaultClassAndResourceResolver();
                this.classResolver = defaultClassAndResourceResolver;
            }
            if (this.resourceResolver == null) {
                if (defaultClassAndResourceResolver == null) {
                    defaultClassAndResourceResolver = new DefaultClassAndResourceResolver();
                }
                this.resourceResolver = defaultClassAndResourceResolver;
            }
            if (this.beanResolver == null) {
                this.beanResolver = new ReflectionBeanResolver(this.classResolver);
            }
            ConfigurationPropertySource propertySource = !this.overriddenProperties.isEmpty() ? this.mainPropertySource.withOverride(ConfigurationPropertySource.fromMap(this.overriddenProperties)) : this.mainPropertySource;
            ConfiguredBeanProvider beanProvider = new ConfiguredBeanProvider(this.classResolver, this.beanResolver, propertySource);
            ServiceManagerImpl serviceManager = new ServiceManagerImpl(this.classResolver, this.resourceResolver, beanProvider);
            RootBuildContext rootBuildContext = new RootBuildContext(serviceManager, failureCollector);
            indexManagerBuildingStateHolder = new IndexManagerBuildingStateHolder(beanProvider, propertySource, rootBuildContext);
            for (Map.Entry<MappingKey<?>, MappingInitiator<?, ?>> entry : this.mappingInitiators.entrySet()) {
                MappingBuildingState mappingBuildingState = new MappingBuildingState(rootBuildContext, propertySource, entry.getKey(), entry.getValue());
                mappingBuildingStates.add(mappingBuildingState);
                mappingBuildingState.collect();
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.createMapper(indexManagerBuildingStateHolder);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            for (MappingBuildingState mappingBuildingState : mappingBuildingStates) {
                mappingBuildingState.createAndAddMapping(mappings);
            }
            checkingRootFailures = true;
            failureCollector.checkNoFailure();
            checkingRootFailures = false;
            return new SearchIntegrationImpl(this.beanResolver, mappings, indexManagerBuildingStateHolder.getBackendsByName(), indexManagerBuildingStateHolder.getIndexManagersByName());
        }
        catch (RuntimeException e) {
            Throwable rethrownException;
            if (checkingRootFailures) {
                rethrownException = e;
            } else {
                try {
                    failureCollector.checkNoFailure();
                    rethrownException = e;
                }
                catch (SearchException e2) {
                    rethrownException = e2;
                    rethrownException.addSuppressed(e);
                }
            }
            SuppressingCloser closer = new SuppressingCloser(rethrownException);
            closer.pushAll(MappingImplementor::close, mappings.values());
            closer.pushAll(MappingBuildingState::closeOnFailure, mappingBuildingStates);
            closer.pushAll(holder -> holder.closeOnFailure(closer), (Object[])new IndexManagerBuildingStateHolder[]{indexManagerBuildingStateHolder});
            closer.pushAll(BeanResolver::close, (Object[])new BeanResolver[]{this.beanResolver});
            throw rethrownException;
        }
    }

    private static class TypeMappingContribution<C> {
        private final MappableTypeModel typeModel;
        private String indexName;
        private final List<C> contributors = new ArrayList<C>();

        TypeMappingContribution(MappableTypeModel typeModel) {
            this.typeModel = typeModel;
        }

        public String getIndexName() {
            return this.indexName;
        }

        public void mapToIndex(String indexName) {
            if (this.indexName != null) {
                throw log.multipleIndexMapping(this.typeModel, this.indexName, indexName);
            }
            this.indexName = indexName;
        }

        public void collectContributor(C contributor) {
            this.contributors.add(contributor);
        }

        public Stream<C> getContributors() {
            return this.contributors.stream();
        }
    }

    private static class MappingBuildingState<C, M> {
        private final MappingBuildContext buildContext;
        private final ConfigurationPropertySource propertySource;
        private final MappingKey<M> mappingKey;
        private final MappingInitiator<C, M> mappingInitiator;
        private final Map<MappableTypeModel, TypeMappingContribution<C>> contributionByType = new LinkedHashMap<MappableTypeModel, TypeMappingContribution<C>>();
        private final List<TypeMetadataDiscoverer<C>> metadataDiscoverers = new ArrayList<TypeMetadataDiscoverer<C>>();
        private boolean multiTenancyEnabled;
        private final Set<MappableTypeModel> typesSubmittedToDiscoverers = new HashSet<MappableTypeModel>();
        private Mapper<M> mapper;

        MappingBuildingState(RootBuildContext rootBuildContext, ConfigurationPropertySource propertySource, MappingKey<M> mappingKey, MappingInitiator<C, M> mappingInitiator) {
            this.mappingKey = mappingKey;
            this.buildContext = new MappingBuildContextImpl(rootBuildContext, mappingKey);
            this.propertySource = propertySource;
            this.mappingInitiator = mappingInitiator;
        }

        void collect() {
            this.mappingInitiator.configure(this.buildContext, this.propertySource, new MappingConfigurationCollectorImpl());
        }

        void createMapper(IndexManagerBuildingStateHolder indexManagerBuildingStateHolder) {
            TypeMetadataContributorProviderImpl contributorProvider = new TypeMetadataContributorProviderImpl();
            this.mapper = this.mappingInitiator.createMapper(this.buildContext, this.propertySource, contributorProvider);
            LinkedHashSet<MappableTypeModel> potentiallyMappedToIndexTypes = new LinkedHashSet<MappableTypeModel>(this.contributionByType.keySet());
            for (MappableTypeModel typeModel : potentiallyMappedToIndexTypes) {
                IndexManagerBuildingState<?> indexManagerBuildingState;
                TypeMappingContribution<C> contribution = this.contributionByType.get(typeModel);
                String indexName = contribution.getIndexName();
                if (indexName == null) continue;
                try {
                    indexManagerBuildingState = indexManagerBuildingStateHolder.startBuilding(indexName, this.multiTenancyEnabled);
                }
                catch (RuntimeException e) {
                    this.buildContext.getFailureCollector().withContext(EventContexts.fromType(typeModel)).withContext(EventContexts.fromIndexName(indexName)).add(e);
                    continue;
                }
                this.mapper.addIndexed(typeModel, indexManagerBuildingState);
            }
        }

        void createAndAddMapping(Map<MappingKey<?>, MappingImplementor<?>> mappings) {
            try {
                MappingImplementor<M> mapping = this.mapper.build();
                mappings.put(this.mappingKey, mapping);
            }
            catch (MappingAbortedException e) {
                Throwable[] suppressed;
                ContextualFailureCollector failureCollector = this.buildContext.getFailureCollector();
                if (!failureCollector.hasFailure()) {
                    throw new AssertionFailure("Caught " + MappingAbortedException.class.getSimpleName() + ", but the mapper did not collect any failure. There is a bug in the mapper, please report it.", (Throwable)e);
                }
                Throwable cause = e.getCause();
                if (cause != null) {
                    failureCollector.add(cause);
                }
                for (Throwable throwable : suppressed = e.getSuppressed()) {
                    failureCollector.add(throwable);
                }
            }
        }

        private TypeMappingContribution<C> getOrCreateContribution(MappableTypeModel typeModel) {
            TypeMappingContribution<C> contribution = this.contributionByType.get(typeModel);
            if (contribution == null) {
                contribution = new TypeMappingContribution(typeModel);
                this.contributionByType.put(typeModel, contribution);
            }
            return contribution;
        }

        private TypeMappingContribution<C> getContributionIncludingAutomaticallyDiscovered(MappableTypeModel typeModel) {
            if (!this.typesSubmittedToDiscoverers.contains(typeModel)) {
                for (TypeMetadataDiscoverer<C> metadataDiscoverer : this.metadataDiscoverers) {
                    Optional<C> discoveredContributor = metadataDiscoverer.discover(typeModel);
                    if (!discoveredContributor.isPresent()) continue;
                    this.getOrCreateContribution(typeModel).collectContributor(discoveredContributor.get());
                }
                this.typesSubmittedToDiscoverers.add(typeModel);
            }
            return this.contributionByType.get(typeModel);
        }

        public void closeOnFailure() {
            if (this.mapper != null) {
                this.mapper.closeOnFailure();
            }
        }

        private class TypeMetadataContributorProviderImpl
        implements TypeMetadataContributorProvider<C> {
            private TypeMetadataContributorProviderImpl() {
            }

            @Override
            public void forEach(MappableTypeModel typeModel, Consumer<C> contributorConsumer) {
                typeModel.getDescendingSuperTypes().map(x$0 -> MappingBuildingState.this.getContributionIncludingAutomaticallyDiscovered(x$0)).filter(Objects::nonNull).flatMap(TypeMappingContribution::getContributors).forEach(contributorConsumer);
            }

            @Override
            public Set<? extends MappableTypeModel> getTypesContributedTo() {
                return Collections.unmodifiableSet(new LinkedHashSet(MappingBuildingState.this.contributionByType.keySet()));
            }
        }

        private class MappingConfigurationCollectorImpl
        implements MappingConfigurationCollector<C> {
            private MappingConfigurationCollectorImpl() {
            }

            @Override
            public void mapToIndex(MappableTypeModel typeModel, String indexName) {
                if (typeModel.isAbstract()) {
                    throw log.cannotMapAbstractTypeToIndex(typeModel, indexName);
                }
                MappingBuildingState.this.getOrCreateContribution(typeModel).mapToIndex(indexName);
            }

            @Override
            public void collectContributor(MappableTypeModel typeModel, C contributor) {
                MappingBuildingState.this.getOrCreateContribution(typeModel).collectContributor(contributor);
            }

            @Override
            public void collectDiscoverer(TypeMetadataDiscoverer<C> metadataDiscoverer) {
                MappingBuildingState.this.metadataDiscoverers.add(metadataDiscoverer);
            }

            @Override
            public void enableMultiTenancy() {
                MappingBuildingState.this.multiTenancyEnabled = true;
            }
        }
    }
}

