/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.util.impl.common.Closer;
import org.hibernate.search.util.impl.common.CollectionHelper;

final class CompositeBeanHolder<T>
implements BeanHolder<List<T>> {
    private final List<? extends BeanHolder<? extends T>> delegates;
    private final List<T> instances;

    CompositeBeanHolder(List<? extends BeanHolder<? extends T>> delegates) {
        this.delegates = delegates;
        ArrayList<T> tmp = new ArrayList<T>(delegates.size());
        for (BeanHolder<T> delegate : delegates) {
            tmp.add(delegate.get());
        }
        this.instances = CollectionHelper.toImmutableList(tmp);
    }

    @Override
    public List<T> get() {
        return this.instances;
    }

    @Override
    public void close() {
        try (Closer closer = new Closer();){
            closer.pushAll(BeanHolder::close, this.delegates);
        }
    }
}

