/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.bean.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.hibernate.search.engine.environment.bean.impl.ConfiguredBeanKey;
import org.hibernate.search.engine.environment.bean.spi.BeanConfigurationContext;
import org.hibernate.search.engine.environment.bean.spi.BeanFactory;
import org.hibernate.search.util.impl.common.Contracts;

final class BeanConfigurationContextImpl
implements BeanConfigurationContext {
    private Map<ConfiguredBeanKey<?>, BeanFactory<?>> explicitlyConfiguredBeans = new HashMap();

    BeanConfigurationContextImpl() {
    }

    @Override
    public <T> void define(Class<T> exposedType, BeanFactory<T> factory) {
        Contracts.assertNotNull(exposedType, (String)"exposedType");
        Contracts.assertNotNull(factory, (String)"factory");
        this.explicitlyConfiguredBeans.put(new ConfiguredBeanKey<T>(exposedType, null), factory);
    }

    @Override
    public <T> void define(Class<T> exposedType, String name, BeanFactory<T> factory) {
        Contracts.assertNotNull(exposedType, (String)"exposedType");
        Contracts.assertNotNull((Object)name, (String)"name");
        Contracts.assertNotNull(factory, (String)"factory");
        this.explicitlyConfiguredBeans.put(new ConfiguredBeanKey<T>(exposedType, name), factory);
    }

    Map<ConfiguredBeanKey<?>, BeanFactory<?>> getConfiguredBeans() {
        return Collections.unmodifiableMap(this.explicitlyConfiguredBeans);
    }
}

