/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.spi;

import java.util.Set;
import org.hibernate.search.engine.logging.impl.EngineEventContextMessages;
import org.hibernate.search.engine.logging.spi.AbstractSimpleEventContextElement;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.util.EventContext;
import org.hibernate.search.util.EventContextElement;
import org.hibernate.search.util.impl.common.CollectionHelper;
import org.jboss.logging.Messages;

public class EventContexts {
    private static final EngineEventContextMessages MESSAGES = (EngineEventContextMessages)Messages.getBundle(EngineEventContextMessages.class);
    private static final EventContext DEFAULT = EventContext.create((EventContextElement)new EventContextElement(){

        public String toString() {
            return "EventContextElement[" + this.render() + "]";
        }

        public String render() {
            return MESSAGES.defaultOnMissingContextElement();
        }
    }, (EventContextElement[])new EventContextElement[0]);
    private static final EventContext INDEX_SCHEMA_ROOT = EventContext.create((EventContextElement)new EventContextElement(){

        public String toString() {
            return "EventContextElement[" + this.render() + "]";
        }

        public String render() {
            return MESSAGES.indexSchemaRoot();
        }
    }, (EventContextElement[])new EventContextElement[0]);

    private EventContexts() {
    }

    public static EventContext getDefault() {
        return DEFAULT;
    }

    public static EventContext fromType(MappableTypeModel typeModel) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<MappableTypeModel>(typeModel){

            @Override
            public String render(MappableTypeModel param) {
                String typeName = param.getName();
                return MESSAGES.type(typeName);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromBackendName(String name) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            @Override
            public String render(String param) {
                return MESSAGES.backend(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexName(String name) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(name){

            @Override
            public String render(String param) {
                return MESSAGES.index(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext fromIndexNames(String ... indexNames) {
        return EventContexts.fromIndexNames(CollectionHelper.asLinkedHashSet((Object[])indexNames));
    }

    public static EventContext fromIndexNames(Set<String> indexNames) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<Set<String>>(indexNames){

            @Override
            public String render(Set<String> indexNames) {
                return MESSAGES.indexes(indexNames);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }

    public static EventContext indexSchemaRoot() {
        return INDEX_SCHEMA_ROOT;
    }

    public static EventContext fromIndexFieldAbsolutePath(String absolutePath) {
        return EventContext.create((EventContextElement)new AbstractSimpleEventContextElement<String>(absolutePath){

            @Override
            public String render(String param) {
                return MESSAGES.indexFieldAbsolutePath(param);
            }
        }, (EventContextElement[])new EventContextElement[0]);
    }
}

