/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractSearchPredicateTerminalContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;

abstract class AbstractMultiFieldPredicateCommonState<B, F extends FieldSetContext<B>>
extends AbstractSearchPredicateTerminalContext<B> {
    private final List<F> fieldSetContexts = new ArrayList<F>();

    AbstractMultiFieldPredicateCommonState(SearchPredicateBuilderFactory<?, B> factory) {
        super(factory);
    }

    public SearchPredicateBuilderFactory<?, B> getFactory() {
        return this.factory;
    }

    public void add(F fieldSetContext) {
        this.fieldSetContexts.add(fieldSetContext);
    }

    List<F> getFieldSetContexts() {
        return this.fieldSetContexts;
    }

    @Override
    protected B toImplementation() {
        ArrayList predicateBuilders = new ArrayList();
        for (FieldSetContext fieldSetContext : this.fieldSetContexts) {
            fieldSetContext.contributePredicateBuilders(predicateBuilders::add);
        }
        if (predicateBuilders.size() > 1) {
            BooleanJunctionPredicateBuilder boolBuilder = this.factory.bool();
            for (Object predicateBuilder : predicateBuilders) {
                boolBuilder.should(predicateBuilder);
            }
            return boolBuilder.toImplementation();
        }
        return (B)predicateBuilders.get(0);
    }

    public static interface FieldSetContext<B> {
        public void contributePredicateBuilders(Consumer<B> var1);
    }
}

