/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.util.function.Function;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.SearchQuery;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQueryContextImpl;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQueryPredicateCollector;
import org.hibernate.search.engine.search.dsl.spi.SearchTargetContext;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

public final class SearchQueryResultContextImpl<T, C, Q>
implements SearchQueryResultContext<Q> {
    private final SearchTargetContext<C> targetContext;
    private final SearchQueryBuilder<T, C> searchQueryBuilder;
    private final Function<SearchQuery<T>, Q> searchQueryWrapperFactory;
    private final SearchQueryPredicateCollector<? super C, ?> searchPredicateCollector;

    public SearchQueryResultContextImpl(SearchTargetContext<C> targetContext, SearchQueryBuilder<T, C> searchQueryBuilder, Function<SearchQuery<T>, Q> searchQueryWrapperFactory) {
        this.targetContext = targetContext;
        this.searchQueryBuilder = searchQueryBuilder;
        this.searchQueryWrapperFactory = searchQueryWrapperFactory;
        this.searchPredicateCollector = new SearchQueryPredicateCollector(targetContext.getSearchPredicateBuilderFactory());
    }

    @Override
    public SearchQueryContext<Q> predicate(SearchPredicate predicate) {
        this.searchPredicateCollector.collect(predicate);
        return this.getNext();
    }

    @Override
    public SearchQueryContext<Q> predicate(Function<? super SearchPredicateFactoryContext, SearchPredicate> dslPredicateContributor) {
        this.searchPredicateCollector.collect(dslPredicateContributor);
        return this.getNext();
    }

    private SearchQueryContext<Q> getNext() {
        return new SearchQueryContextImpl<T, Q, C>(this.targetContext, this.searchQueryBuilder, this.searchQueryWrapperFactory, this.searchPredicateCollector);
    }
}

