/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.query.impl;

import java.util.function.Consumer;
import org.hibernate.search.engine.search.SearchSort;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.sort.spi.SearchSortBuilderFactory;

class SearchQuerySortCollector<C, B> {
    private final SearchSortBuilderFactory<C, B> factory;
    private final SearchSortDslContextImpl<B> rootDslContext;

    SearchQuerySortCollector(SearchSortBuilderFactory<C, B> factory) {
        this.factory = factory;
        this.rootDslContext = new SearchSortDslContextImpl<B>(factory);
    }

    void contribute(C collector) {
        this.factory.contribute(collector, this.rootDslContext.getResultingBuilders());
    }

    void collect(SearchSort sort) {
        this.factory.toImplementation(sort, this.rootDslContext::addChild);
    }

    void collect(Consumer<? super SearchSortContainerContext> dslPredicateContributor) {
        DefaultSearchSortContainerContext<B> containerContext = new DefaultSearchSortContainerContext<B>(this.factory, this.rootDslContext);
        dslPredicateContributor.accept(containerContext);
    }
}

