/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.query.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.engine.search.query.spi.LoadingResult;
import org.hibernate.search.engine.search.query.spi.ProjectionHitMapper;
import org.hibernate.search.util.impl.common.CollectionHelper;

public class DefaultProjectionHitMapper<R, O>
implements ProjectionHitMapper<R, O> {
    private final Function<DocumentReference, R> documentReferenceTransformer;
    private final ObjectLoader<R, O> objectLoader;
    private final List<R> referencesToLoad = new ArrayList<R>();

    public DefaultProjectionHitMapper(Function<DocumentReference, R> documentReferenceTransformer, ObjectLoader<R, O> objectLoader) {
        this.documentReferenceTransformer = documentReferenceTransformer;
        this.objectLoader = objectLoader;
    }

    @Override
    public R convertReference(DocumentReference reference) {
        return this.documentReferenceTransformer.apply(reference);
    }

    @Override
    public Object planLoading(DocumentReference reference) {
        this.referencesToLoad.add(this.documentReferenceTransformer.apply(reference));
        return this.referencesToLoad.size() - 1;
    }

    @Override
    public LoadingResult<O> loadBlocking() {
        return new DefaultLoadingResult(this.objectLoader.loadBlocking(this.referencesToLoad));
    }

    private static class DefaultLoadingResult<O>
    implements LoadingResult<O> {
        private final List<O> loadedObjects;

        private DefaultLoadingResult(List<O> loadedObjects) {
            this.loadedObjects = CollectionHelper.toImmutableList(loadedObjects);
        }

        @Override
        public O getLoaded(Object key) {
            return this.loadedObjects.get((Integer)key);
        }
    }
}

