/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.hibernate.search.engine.environment.bean.BeanReference;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ConvertUtils {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());

    private ConvertUtils() {
    }

    public static <T> T convert(Class<T> expectedType, Function<String, T> parser, Object value) {
        if (expectedType.isInstance(value)) {
            return expectedType.cast(value);
        }
        try {
            return parser.apply((String)value);
        }
        catch (RuntimeException e) {
            throw log.invalidPropertyValue(expectedType, e.getMessage(), e);
        }
    }

    public static Boolean convertBoolean(Object value) {
        try {
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String) {
                String string = (String)value;
                if ("false".equalsIgnoreCase(string)) {
                    return false;
                }
                if ("true".equalsIgnoreCase(string)) {
                    return true;
                }
            }
        }
        catch (RuntimeException e) {
            throw log.invalidBooleanPropertyValue(e.getMessage(), e);
        }
        throw log.invalidBooleanPropertyValue("", null);
    }

    public static Integer convertInteger(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).intValue();
            }
            if (value instanceof String) {
                return Integer.parseInt((String)value);
            }
        }
        catch (RuntimeException e) {
            throw log.invalidIntegerPropertyValue(e.getMessage(), e);
        }
        throw log.invalidIntegerPropertyValue("", null);
    }

    public static Long convertLong(Object value) {
        try {
            if (value instanceof Number) {
                return ((Number)value).longValue();
            }
            if (value instanceof String) {
                return Long.parseLong((String)value);
            }
        }
        catch (RuntimeException e) {
            throw log.invalidLongPropertyValue(e.getMessage(), e);
        }
        throw log.invalidLongPropertyValue("", null);
    }

    public static <T> BeanReference<? extends T> convertBeanReference(Class<T> expectedType, Object value) {
        try {
            if (expectedType.isInstance(value)) {
                return BeanReference.ofInstance(expectedType.cast(value));
            }
            if (value instanceof BeanReference) {
                return ((BeanReference)value).asSubTypeOf(expectedType);
            }
            if (value instanceof Class) {
                Class castedValue = (Class)value;
                if (!expectedType.isAssignableFrom(castedValue)) {
                    throw log.invalidBeanType(expectedType, castedValue);
                }
                Class castedValueAsChildType = (Class)value;
                return BeanReference.of(castedValueAsChildType);
            }
            if (value instanceof String) {
                return BeanReference.of(expectedType, (String)value);
            }
        }
        catch (RuntimeException e) {
            throw log.invalidBeanReferencePropertyValue(expectedType, e.getMessage(), e);
        }
        throw log.invalidBeanReferencePropertyValue(expectedType, "", null);
    }

    public static <T> List<T> convertMultiValue(Pattern separatorPattern, Function<Object, T> elementConverter, Object value) {
        if (value instanceof Collection) {
            return ((Collection)value).stream().map(ConvertUtils::trimIfString).filter(Objects::nonNull).map(elementConverter).collect(Collectors.toList());
        }
        if (value instanceof String) {
            return separatorPattern.splitAsStream((String)value).map(ConvertUtils::trimIfString).filter(Objects::nonNull).map(elementConverter).collect(Collectors.toList());
        }
        throw log.invalidMultiPropertyValue();
    }

    static Object trimIfString(Object value) {
        if (value instanceof String) {
            String stringValue = (String)value;
            String trimmed = stringValue.trim();
            return trimmed.isEmpty() ? null : trimmed;
        }
        return value;
    }
}

