/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.function.Function;
import org.hibernate.search.engine.backend.document.DocumentElement;
import org.hibernate.search.engine.backend.index.IndexManager;
import org.hibernate.search.engine.backend.index.spi.IndexDocumentWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkExecutor;
import org.hibernate.search.engine.backend.index.spi.IndexWorkPlan;
import org.hibernate.search.engine.common.impl.MappedIndexSearchScopeBuilderImpl;
import org.hibernate.search.engine.mapper.mapping.context.spi.MappingContextImplementor;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexManager;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchScopeBuilder;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;

class MappedIndexManagerImpl<D extends DocumentElement>
implements MappedIndexManager<D> {
    private final IndexManagerImplementor<D> implementor;

    MappedIndexManagerImpl(IndexManagerImplementor<D> implementor) {
        this.implementor = implementor;
    }

    @Override
    public IndexManager toAPI() {
        return this.implementor.toAPI();
    }

    @Override
    public IndexWorkPlan<D> createWorkPlan(SessionContextImplementor sessionContext) {
        return this.implementor.createWorkPlan(sessionContext);
    }

    @Override
    public IndexDocumentWorkExecutor<D> createDocumentWorkExecutor(SessionContextImplementor sessionContext) {
        return this.implementor.createDocumentWorkExecutor(sessionContext);
    }

    @Override
    public IndexWorkExecutor createWorkExecutor() {
        return this.implementor.createWorkExecutor();
    }

    @Override
    public <R, O> MappedIndexSearchScopeBuilder<R, O> createSearchScopeBuilder(MappingContextImplementor mappingContext, Function<DocumentReference, R> documentReferenceTransformer) {
        return new MappedIndexSearchScopeBuilderImpl(this.implementor, mappingContext, documentReferenceTransformer);
    }

    @Override
    public void addTo(MappedIndexSearchScopeBuilder<?, ?> builder) {
        ((MappedIndexSearchScopeBuilderImpl)builder).add(this.implementor);
    }
}

