/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.mapper.mapping.spi.MappedIndexSearchScope;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.DocumentReference;
import org.hibernate.search.engine.search.SearchProjection;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.projection.impl.DefaultSearchProjectionFactoryContext;
import org.hibernate.search.engine.search.dsl.query.SearchQueryResultContext;
import org.hibernate.search.engine.search.dsl.query.impl.SearchQueryResultContextImpl;
import org.hibernate.search.engine.search.dsl.sort.SearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortContainerContext;
import org.hibernate.search.engine.search.dsl.spi.IndexSearchScope;
import org.hibernate.search.engine.search.loading.spi.ObjectLoader;
import org.hibernate.search.engine.search.query.impl.DefaultProjectionHitMapper;
import org.hibernate.search.engine.search.query.impl.NoLoadingProjectionHitMapper;
import org.hibernate.search.engine.search.query.spi.IndexSearchQuery;
import org.hibernate.search.engine.search.query.spi.SearchQueryBuilder;

class MappedIndexSearchScopeImpl<C, R, O>
implements MappedIndexSearchScope<R, O> {
    private final IndexSearchScope<C> delegate;
    private final Function<DocumentReference, R> documentReferenceTransformer;

    MappedIndexSearchScopeImpl(IndexSearchScope<C> delegate, Function<DocumentReference, R> documentReferenceTransformer) {
        this.delegate = delegate;
        this.documentReferenceTransformer = documentReferenceTransformer;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "delegate=" + this.delegate + "]";
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsLoadedObject(SessionContextImplementor sessionContext, ObjectLoader<R, T> objectLoader, Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory) {
        DefaultProjectionHitMapper<R, T> projectionHitMapper = new DefaultProjectionHitMapper<R, T>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<T, C> builder = this.delegate.getSearchQueryBuilderFactory().asObject(sessionContext, projectionHitMapper);
        return new SearchQueryResultContextImpl<T, C, Q>(this.delegate, builder, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsReference(SessionContextImplementor sessionContext, Function<IndexSearchQuery<R>, Q> searchQueryWrapperFactory) {
        NoLoadingProjectionHitMapper<R> referenceHitMapper = new NoLoadingProjectionHitMapper<R>(this.documentReferenceTransformer);
        SearchQueryBuilder builder = this.delegate.getSearchQueryBuilderFactory().asReference(sessionContext, referenceHitMapper);
        return new SearchQueryResultContextImpl(this.delegate, builder, searchQueryWrapperFactory);
    }

    @Override
    public <T, Q> SearchQueryResultContext<Q> queryAsProjection(SessionContextImplementor sessionContext, ObjectLoader<R, O> objectLoader, Function<IndexSearchQuery<T>, Q> searchQueryWrapperFactory, SearchProjection<T> projection) {
        DefaultProjectionHitMapper<R, O> projectionHitMapper = new DefaultProjectionHitMapper<R, O>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<T, C> builder = this.delegate.getSearchQueryBuilderFactory().asProjection(sessionContext, projectionHitMapper, projection);
        return new SearchQueryResultContextImpl<T, C, Q>(this.delegate, builder, searchQueryWrapperFactory);
    }

    @Override
    public <Q> SearchQueryResultContext<Q> queryAsProjections(SessionContextImplementor sessionContext, ObjectLoader<R, O> objectLoader, Function<IndexSearchQuery<List<?>>, Q> searchQueryWrapperFactory, SearchProjection<?> ... projections) {
        DefaultProjectionHitMapper<R, O> projectionHitMapper = new DefaultProjectionHitMapper<R, O>(this.documentReferenceTransformer, objectLoader);
        SearchQueryBuilder<List<R>, C> builder = this.delegate.getSearchQueryBuilderFactory().asProjections(sessionContext, projectionHitMapper, projections);
        return new SearchQueryResultContextImpl(this.delegate, builder, searchQueryWrapperFactory);
    }

    @Override
    public SearchPredicateFactoryContext predicate() {
        return new DefaultSearchPredicateFactoryContext(this.delegate.getSearchPredicateBuilderFactory());
    }

    @Override
    public SearchSortContainerContext sort() {
        return new DefaultSearchSortContainerContext(this.delegate.getSearchSortBuilderFactory());
    }

    @Override
    public SearchProjectionFactoryContext<R, O> projection() {
        return new DefaultSearchProjectionFactoryContext(this.delegate.getSearchProjectionFactory());
    }
}

