/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.logging.impl;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter;
import org.hibernate.search.engine.logging.spi.MappingKeyFormatter;
import org.hibernate.search.engine.mapper.mapping.spi.MappingKey;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.util.common.SearchException;
import org.hibernate.search.util.common.logging.impl.ClassFormatter;
import org.hibernate.search.util.common.reporting.EventContext;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.Logger;

public class Log_$logger
extends DelegatingBasicLogger
implements Log,
BasicLogger,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    private static final Locale LOCALE = Locale.ROOT;
    private static final String noPublicNoArgConstructor = "HSEARCH000242: Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor";
    private static final String simpleQueryStringCannotBeNull = "HSEARCH000334: Invalid simple query string: the string must be non-null. Null value was passed to simple query string predicate on fields %1$s.";
    private static final String unableToConvertConfigurationProperty = "HSEARCH000501: Unable to convert configuration property '%1$s' with value '%2$s': %3$s";
    private static final String invalidPropertyValue = "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed. %2$s";
    private static final String invalidBooleanPropertyValue = "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    private static final String invalidIntegerPropertyValue = "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    private static final String invalidLongPropertyValue = "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    private static final String invalidMultiPropertyValue = "HSEARCH000506: Invalid multi value: expected either a Collection or a String.";
    private static final String cannotAddMultiplePredicatesToQueryRoot = "HSEARCH000507: Cannot add multiple predicates to the query root; use an explicit boolean predicate instead.";
    private static final String cannotAddMultiplePredicatesToNestedPredicate = "HSEARCH000509: Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.";
    private static final String matchPredicateCannotMatchNullValue = "HSEARCH000511: Invalid value: the value to match in match predicates must be non-null.";
    private static final String rangePredicateCannotMatchNullValue = "HSEARCH000512: Invalid value: at least one bound in range predicates must be non-null.";
    private static final String cannotMapAbstractTypeToIndex = "HSEARCH000513: Cannot map type '%1$s' to index '%2$s', because this type is abstract. Index mappings are not inherited: they apply to exact instances of a given type. As a result, mapping an abstract type to an index does not make sense, since the index would always be empty.";
    private static final String relativeFieldNameCannotBeNullOrEmpty = "HSEARCH000514: Field name '%1$s' is invalid: field names cannot be null or empty.";
    private static final String relativeFieldNameCannotContainDot = "HSEARCH000515: Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    private static final String invalidGeoPolygonFirstPointNotIdenticalToLastPoint = "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    private static final String cannotAddSortToUsedContext = "HSEARCH000518: Cannot add a sort to this DSL context anymore, because the DSL context was already closed. If you want to re-use sorts, do not re-use the sort DSL context objects, but rather build SearchSort objects.";
    private static final String boostrapCollectedFailureLimitReached = "HSEARCH000519: Hibernate Search bootstrap failed; stopped collecting failures after '%2$s' failures. Failures:\n%1$s";
    private static final String bootstrapCollectedFailures = "HSEARCH000520: Hibernate Search bootstrap failed. Failures:\n%1$s";
    private static final String newBootstrapCollectedFailure = "HSEARCH000521: Hibernate Search bootstrap encountered a non-fatal failure; continuing bootstrap for now to list all mapping problems, but the bootstrap process will ultimately be aborted.\nContext: %1$s\nFailure:";
    private static final String unexpectedEmptyEventContext = "HSEARCH000522: Unexpected empty event context; there is a bug in Hibernate Search, please report it";
    private static final String cannotCallDslExtensionIfSupportedAfterOrElse = "HSEARCH000525: Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    private static final String dslExtensionNoMatch = "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    private static final String unableToInstantiateComponent = "HSEARCH000527: Unable to instantiate %1$s, class '%2$s': %3$s";
    private static final String securityManagerLoadingError = "HSEARCH000528: %2$s defined for component %1$s could not be instantiated because of a security manager error";
    private static final String unableToFindComponentImplementation = "HSEARCH000529: Unable to find %1$s implementation class: %2$s";
    private static final String unableToLoadTheClass = "HSEARCH000530: Unable to load class [%1$s]";
    private static final String multipleIndexMapping = "HSEARCH000531: Trying to map the Type '%1$s' mapped to multiple indexes: '%2$s', '%3$s'.";
    private static final String noMappingRegistered = "HSEARCH000532: No mapping registered for mapping key: '%1$s'.";
    private static final String noBackendRegistered = "HSEARCH000533: No backend registered for backend name: '%1$s'.";
    private static final String noIndexManagerRegistered = "HSEARCH000534: No index manager registered for index manager name: '%1$s'.";
    private static final String unableToInstantiateClass = "HSEARCH000540: Unable to instantiate class '%1$s': %2$s.";
    private static final String interfaceImplementedExpected = "HSEARCH000541: Wrong configuration of %1$s: class %2$s does not implement interface %3$s.";
    private static final String subtypeExpected = "HSEARCH000542: Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.";
    private static final String implementationRequired = "HSEARCH000543: %2$s defined for component %1$s is an interface: implementation required.";
    private static final String missingConstructor = "HSEARCH000544: %2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.";
    private static final String notAssignableImplementation = "HSEARCH000545: Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.";
    private static final String indexedEmbeddedCyclicRecursion = "HSEARCH000546: Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.";
    private static final String invalidBeanReferencePropertyValue = "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    private static final String invalidBeanType = "HSEARCH000548: Invalid bean type: type '%2$s' is not assignable to '%1$s'.";
    private static final String backendTypeCannotBeNullOrEmpty = "HSEARCH000549: Missing backend type for backend '%1$s'. Set the property '%2$s' to a supported value.";
    private static final String indexBackendCannotBeNullOrEmpty = "HSEARCH000550: Missing backend reference for index '%1$s'. Set the property '%2$s' to a supported value or set '%3$s' to set a default value for all indexes.";
    private static final String perFieldBoostWithConstantScore = "HSEARCH000551: It is not possible to use per-field boosts together with withConstantScore option";
    private static final String phrasePredicateCannotMatchNullPhrase = "HSEARCH000552: Invalid phrase: the phrase to match in phrase predicates must be non-null.";
    private static final String invalidPhrasePredicateSlop = "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    private static final String invalidFuzzyMaximumEditDistance = "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    private static final String invalidExactPrefixLength = "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    private static final String wildcardPredicateCannotMatchNullPattern = "HSEARCH000556: Invalid pattern: the pattern to match in wildcard predicates must be non-null.";

    public Log_$logger(Logger log) {
        super(log);
    }

    protected Locale getLoggingLocale() {
        return LOCALE;
    }

    protected String noPublicNoArgConstructor$str() {
        return noPublicNoArgConstructor;
    }

    @Override
    public final SearchException noPublicNoArgConstructor(String componentName, Class<?> clazz) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noPublicNoArgConstructor$str(), componentName, new ClassFormatter(clazz)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String simpleQueryStringCannotBeNull$str() {
        return simpleQueryStringCannotBeNull;
    }

    @Override
    public final SearchException simpleQueryStringCannotBeNull(Collection<String> strings) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.simpleQueryStringCannotBeNull$str(), strings));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToConvertConfigurationProperty$str() {
        return unableToConvertConfigurationProperty;
    }

    @Override
    public final SearchException unableToConvertConfigurationProperty(String key, Object rawValue, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPropertyValue$str() {
        return invalidPropertyValue;
    }

    @Override
    public final SearchException invalidPropertyValue(Class<?> expectedType, String errorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPropertyValue$str(), new ClassFormatter(expectedType), errorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidBooleanPropertyValue$str() {
        return invalidBooleanPropertyValue;
    }

    @Override
    public final SearchException invalidBooleanPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBooleanPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidIntegerPropertyValue$str() {
        return invalidIntegerPropertyValue;
    }

    @Override
    public final SearchException invalidIntegerPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidIntegerPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidLongPropertyValue$str() {
        return invalidLongPropertyValue;
    }

    @Override
    public final SearchException invalidLongPropertyValue(String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidLongPropertyValue$str(), nestedErrorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidMultiPropertyValue$str() {
        return invalidMultiPropertyValue;
    }

    @Override
    public final SearchException invalidMultiPropertyValue() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidMultiPropertyValue$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddMultiplePredicatesToQueryRoot$str() {
        return cannotAddMultiplePredicatesToQueryRoot;
    }

    @Override
    public final SearchException cannotAddMultiplePredicatesToQueryRoot() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAddMultiplePredicatesToQueryRoot$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddMultiplePredicatesToNestedPredicate$str() {
        return cannotAddMultiplePredicatesToNestedPredicate;
    }

    @Override
    public final SearchException cannotAddMultiplePredicatesToNestedPredicate() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAddMultiplePredicatesToNestedPredicate$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String matchPredicateCannotMatchNullValue$str() {
        return matchPredicateCannotMatchNullValue;
    }

    @Override
    public final SearchException matchPredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.matchPredicateCannotMatchNullValue$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String rangePredicateCannotMatchNullValue$str() {
        return rangePredicateCannotMatchNullValue;
    }

    @Override
    public final SearchException rangePredicateCannotMatchNullValue(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.rangePredicateCannotMatchNullValue$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotMapAbstractTypeToIndex$str() {
        return cannotMapAbstractTypeToIndex;
    }

    @Override
    public final SearchException cannotMapAbstractTypeToIndex(MappableTypeModel typeModel, String indexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotMapAbstractTypeToIndex$str(), new MappableTypeModelFormatter(typeModel), indexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return relativeFieldNameCannotBeNullOrEmpty;
    }

    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String relativeFieldNameCannotContainDot$str() {
        return relativeFieldNameCannotContainDot;
    }

    @Override
    public final SearchException relativeFieldNameCannotContainDot(String relativeFieldName, EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return invalidGeoPolygonFirstPointNotIdenticalToLastPoint;
    }

    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(GeoPoint firstPoint, GeoPoint lastPoint) {
        IllegalArgumentException result = new IllegalArgumentException(String.format(this.getLoggingLocale(), this.invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String cannotAddSortToUsedContext$str() {
        return cannotAddSortToUsedContext;
    }

    @Override
    public final SearchException cannotAddSortToUsedContext() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotAddSortToUsedContext$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String boostrapCollectedFailureLimitReached$str() {
        return boostrapCollectedFailureLimitReached;
    }

    @Override
    public final SearchException boostrapCollectedFailureLimitReached(String renderedFailures, int failureCount) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.boostrapCollectedFailureLimitReached$str(), renderedFailures, failureCount));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String bootstrapCollectedFailures$str() {
        return bootstrapCollectedFailures;
    }

    @Override
    public final SearchException bootstrapCollectedFailures(String renderedFailures) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.bootstrapCollectedFailures$str(), renderedFailures));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    @Override
    public final void newBootstrapCollectedFailure(String context, Throwable failure) {
        this.log.logf(FQCN, Logger.Level.ERROR, failure, this.newBootstrapCollectedFailure$str(), (Object)context);
    }

    protected String newBootstrapCollectedFailure$str() {
        return newBootstrapCollectedFailure;
    }

    @Override
    public final void unexpectedEmptyEventContext(Throwable exceptionForStackTrace) {
        this.log.logf(FQCN, Logger.Level.DEBUG, exceptionForStackTrace, this.unexpectedEmptyEventContext$str(), new Object[0]);
    }

    protected String unexpectedEmptyEventContext$str() {
        return unexpectedEmptyEventContext;
    }

    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return cannotCallDslExtensionIfSupportedAfterOrElse;
    }

    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.cannotCallDslExtensionIfSupportedAfterOrElse$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String dslExtensionNoMatch$str() {
        return dslExtensionNoMatch;
    }

    @Override
    public final SearchException dslExtensionNoMatch(List<?> attemptedExtensions) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.dslExtensionNoMatch$str(), attemptedExtensions));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateComponent$str() {
        return unableToInstantiateComponent;
    }

    @Override
    public final SearchException unableToInstantiateComponent(String componentDescription, Class<?> classToLoad, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateComponent$str(), componentDescription, new ClassFormatter(classToLoad), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String securityManagerLoadingError$str() {
        return securityManagerLoadingError;
    }

    @Override
    public final SearchException securityManagerLoadingError(String componentDescription, Class<?> classToLoad, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.securityManagerLoadingError$str(), componentDescription, new ClassFormatter(classToLoad)), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToFindComponentImplementation$str() {
        return unableToFindComponentImplementation;
    }

    @Override
    public final SearchException unableToFindComponentImplementation(String componentDescription, String classNameToLoad, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToFindComponentImplementation$str(), componentDescription, classNameToLoad), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToLoadTheClass$str() {
        return unableToLoadTheClass;
    }

    @Override
    public final ClassLoadingException unableToLoadTheClass(String className, Throwable cause) {
        ClassLoadingException result = new ClassLoadingException(String.format(this.getLoggingLocale(), this.unableToLoadTheClass$str(), className), cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String multipleIndexMapping$str() {
        return multipleIndexMapping;
    }

    @Override
    public final SearchException multipleIndexMapping(MappableTypeModel typeModel, String indexName, String otherIndexName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.multipleIndexMapping$str(), new MappableTypeModelFormatter(typeModel), indexName, otherIndexName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noMappingRegistered$str() {
        return noMappingRegistered;
    }

    @Override
    public final SearchException noMappingRegistered(MappingKey<?, ?> mappingKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noMappingRegistered$str(), new MappingKeyFormatter(mappingKey)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noBackendRegistered$str() {
        return noBackendRegistered;
    }

    @Override
    public final SearchException noBackendRegistered(String backendName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noBackendRegistered$str(), backendName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String noIndexManagerRegistered$str() {
        return noIndexManagerRegistered;
    }

    @Override
    public final SearchException noIndexManagerRegistered(String indexManagerName) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.noIndexManagerRegistered$str(), indexManagerName));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String unableToInstantiateClass$str() {
        return unableToInstantiateClass;
    }

    @Override
    public final SearchException unableToInstantiateClass(Class<?> classToLoad, String causeMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.unableToInstantiateClass$str(), new ClassFormatter(classToLoad), causeMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String interfaceImplementedExpected$str() {
        return interfaceImplementedExpected;
    }

    @Override
    public final SearchException interfaceImplementedExpected(String component, Class<?> classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.interfaceImplementedExpected$str(), component, new ClassFormatter(classToLoad), new ClassFormatter(superType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String subtypeExpected$str() {
        return subtypeExpected;
    }

    @Override
    public final SearchException subtypeExpected(String component, Class<?> classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.subtypeExpected$str(), component, new ClassFormatter(classToLoad), new ClassFormatter(superType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String implementationRequired$str() {
        return implementationRequired;
    }

    @Override
    public final SearchException implementationRequired(String component, Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.implementationRequired$str(), component, new ClassFormatter(classToLoad)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String missingConstructor$str() {
        return missingConstructor;
    }

    @Override
    public final SearchException missingConstructor(String component, Class<?> classToLoad) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.missingConstructor$str(), component, new ClassFormatter(classToLoad)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String notAssignableImplementation$str() {
        return notAssignableImplementation;
    }

    @Override
    public final SearchException notAssignableImplementation(String component, String classToLoad, Class<?> superType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.notAssignableImplementation$str(), component, classToLoad, new ClassFormatter(superType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexedEmbeddedCyclicRecursion$str() {
        return indexedEmbeddedCyclicRecursion;
    }

    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(String cyclicRecursionPath, MappableTypeModel parentTypeModel) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexedEmbeddedCyclicRecursion$str(), cyclicRecursionPath, new MappableTypeModelFormatter(parentTypeModel)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidBeanReferencePropertyValue$str() {
        return invalidBeanReferencePropertyValue;
    }

    @Override
    public final SearchException invalidBeanReferencePropertyValue(Class<?> expectedType, String nestedErrorMessage, Exception cause) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanReferencePropertyValue$str(), new ClassFormatter(expectedType), nestedErrorMessage), (Throwable)cause);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidBeanType$str() {
        return invalidBeanType;
    }

    @Override
    public final SearchException invalidBeanType(Class<?> expectedSuperType, Class<?> actualType) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidBeanType$str(), new ClassFormatter(expectedSuperType), new ClassFormatter(actualType)));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String backendTypeCannotBeNullOrEmpty$str() {
        return backendTypeCannotBeNullOrEmpty;
    }

    @Override
    public final SearchException backendTypeCannotBeNullOrEmpty(String backendName, String key) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.backendTypeCannotBeNullOrEmpty$str(), backendName, key));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String indexBackendCannotBeNullOrEmpty$str() {
        return indexBackendCannotBeNullOrEmpty;
    }

    @Override
    public final SearchException indexBackendCannotBeNullOrEmpty(String indexName, String key, String defaultKey) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.indexBackendCannotBeNullOrEmpty$str(), indexName, key, defaultKey));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String perFieldBoostWithConstantScore$str() {
        return perFieldBoostWithConstantScore;
    }

    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.perFieldBoostWithConstantScore$str(), new Object[0]));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String phrasePredicateCannotMatchNullPhrase$str() {
        return phrasePredicateCannotMatchNullPhrase;
    }

    @Override
    public final SearchException phrasePredicateCannotMatchNullPhrase(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.phrasePredicateCannotMatchNullPhrase$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidPhrasePredicateSlop$str() {
        return invalidPhrasePredicateSlop;
    }

    @Override
    public final SearchException invalidPhrasePredicateSlop(int slop) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidPhrasePredicateSlop$str(), slop));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidFuzzyMaximumEditDistance$str() {
        return invalidFuzzyMaximumEditDistance;
    }

    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(int maximumEditDistance) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String invalidExactPrefixLength$str() {
        return invalidExactPrefixLength;
    }

    @Override
    public final SearchException invalidExactPrefixLength(int exactPrefixLength) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.invalidExactPrefixLength$str(), exactPrefixLength));
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }

    protected String wildcardPredicateCannotMatchNullPattern$str() {
        return wildcardPredicateCannotMatchNullPattern;
    }

    @Override
    public final SearchException wildcardPredicateCannotMatchNullPattern(EventContext context) {
        SearchException result = new SearchException(String.format(this.getLoggingLocale(), this.wildcardPredicateCannotMatchNullPattern$str(), new Object[0]), context);
        StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}

