/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.hibernate.search.engine.search.SearchPredicate;
import org.hibernate.search.engine.search.dsl.predicate.MatchAllPredicateContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactoryContext;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractSearchPredicateTerminalContext;
import org.hibernate.search.engine.search.predicate.spi.BooleanJunctionPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.MatchAllPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;

class MatchAllPredicateContextImpl<B>
extends AbstractSearchPredicateTerminalContext<B>
implements MatchAllPredicateContext {
    private final SearchPredicateFactoryContext factoryContext;
    private final MatchAllPredicateBuilder<B> matchAllBuilder;
    private MatchAllExceptContext exceptContext;

    MatchAllPredicateContextImpl(SearchPredicateBuilderFactory<?, B> factory, SearchPredicateFactoryContext factoryContext) {
        super(factory);
        this.factoryContext = factoryContext;
        this.matchAllBuilder = factory.matchAll();
    }

    @Override
    public MatchAllPredicateContext boostedTo(float boost) {
        this.matchAllBuilder.boost(boost);
        return this;
    }

    @Override
    public MatchAllPredicateContext except(SearchPredicate searchPredicate) {
        this.getExceptContext().addClause(searchPredicate);
        return this;
    }

    @Override
    public MatchAllPredicateContext except(Function<? super SearchPredicateFactoryContext, ? extends SearchPredicateTerminalContext> clauseContributor) {
        this.getExceptContext().addClause(clauseContributor);
        return this;
    }

    @Override
    protected B toImplementation() {
        if (this.exceptContext != null) {
            return this.exceptContext.toImplementation(this.matchAllBuilder.toImplementation());
        }
        return this.matchAllBuilder.toImplementation();
    }

    private MatchAllExceptContext getExceptContext() {
        if (this.exceptContext == null) {
            this.exceptContext = new MatchAllExceptContext();
        }
        return this.exceptContext;
    }

    private class MatchAllExceptContext {
        private final BooleanJunctionPredicateBuilder<B> booleanBuilder;
        private final List<B> clauseBuilders = new ArrayList();

        MatchAllExceptContext() {
            this.booleanBuilder = MatchAllPredicateContextImpl.this.factory.bool();
        }

        void addClause(Function<? super SearchPredicateFactoryContext, ? extends SearchPredicateTerminalContext> clauseContributor) {
            this.addClause(clauseContributor.apply(MatchAllPredicateContextImpl.this.factoryContext).toPredicate());
        }

        void addClause(SearchPredicate predicate) {
            this.clauseBuilders.add(MatchAllPredicateContextImpl.this.factory.toImplementation(predicate));
        }

        B toImplementation(B matchAllBuilder) {
            this.booleanBuilder.must(matchAllBuilder);
            for (Object builder : this.clauseBuilders) {
                this.booleanBuilder.mustNot(builder);
            }
            return this.booleanBuilder.toImplementation();
        }
    }
}

