/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.MatchPredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.MatchPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.MatchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class MatchPredicateFieldSetContextImpl<B>
implements MatchPredicateFieldSetContext,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetContext<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<MatchPredicateBuilder<B>> predicateBuilders = new ArrayList<MatchPredicateBuilder<B>>();
    private Float fieldSetBoost;

    MatchPredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths, DslConverter dslConverter) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.match(absoluteFieldPath, dslConverter));
        }
    }

    @Override
    public MatchPredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new MatchPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths), DslConverter.ENABLED);
    }

    @Override
    public MatchPredicateFieldSetContext orRawFields(String ... absoluteFieldPaths) {
        return new MatchPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths), DslConverter.DISABLED);
    }

    @Override
    public MatchPredicateFieldSetContext boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public MatchPredicateTerminalContext matching(Object value) {
        return this.commonState.matching(value);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (MatchPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, MatchPredicateFieldSetContextImpl<B>>
    implements MatchPredicateTerminalContext {
        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        MatchPredicateTerminalContext matching(Object value) {
            if (value == null) {
                throw log.matchPredicateCannotMatchNullValue(this.getEventContext());
            }
            for (MatchPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetContext.predicateBuilders) {
                    predicateBuilder.value(value);
                }
            }
            return this;
        }

        @Override
        public MatchPredicateTerminalContext fuzzy(int maxEditDistance, int exactPrefixLength) {
            if (maxEditDistance < 0 || 2 < maxEditDistance) {
                throw log.invalidFuzzyMaximumEditDistance(maxEditDistance);
            }
            if (exactPrefixLength < 0) {
                throw log.invalidExactPrefixLength(exactPrefixLength);
            }
            for (MatchPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                for (MatchPredicateBuilder predicateBuilder : fieldSetContext.predicateBuilders) {
                    predicateBuilder.fuzzy(maxEditDistance, exactPrefixLength);
                }
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

