/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.search.engine.search.dsl.predicate.SpatialWithinPredicateFieldSetContext;
import org.hibernate.search.engine.search.dsl.predicate.SpatialWithinPredicateTerminalContext;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinBoundingBoxPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinCirclePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SpatialWithinPolygonPredicateBuilder;
import org.hibernate.search.engine.spatial.DistanceUnit;
import org.hibernate.search.engine.spatial.GeoBoundingBox;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.hibernate.search.engine.spatial.GeoPolygon;
import org.hibernate.search.util.common.impl.CollectionHelper;
import org.hibernate.search.util.common.impl.Contracts;

class SpatialWithinPredicateFieldSetContextImpl<B>
implements SpatialWithinPredicateFieldSetContext,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetContext<B> {
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<SearchPredicateBuilder<B>> predicateBuilders;
    private Float fieldSetBoost;

    SpatialWithinPredicateFieldSetContextImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = CollectionHelper.toImmutableList(absoluteFieldPaths);
        this.predicateBuilders = new ArrayList<SearchPredicateBuilder<B>>(absoluteFieldPaths.size());
    }

    @Override
    public SpatialWithinPredicateFieldSetContext orFields(String ... absoluteFieldPaths) {
        return new SpatialWithinPredicateFieldSetContextImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SpatialWithinPredicateFieldSetContext boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public SpatialWithinPredicateTerminalContext circle(GeoPoint center, double radius, DistanceUnit unit) {
        Contracts.assertNotNull((Object)center, (String)"center");
        Contracts.assertNotNull((Object)radius, (String)"radius");
        Contracts.assertNotNull((Object)((Object)unit), (String)"unit");
        return this.commonState.circle(center, radius, unit);
    }

    @Override
    public SpatialWithinPredicateTerminalContext polygon(GeoPolygon polygon) {
        Contracts.assertNotNull((Object)polygon, (String)"polygon");
        return this.commonState.polygon(polygon);
    }

    @Override
    public SpatialWithinPredicateTerminalContext boundingBox(GeoBoundingBox boundingBox) {
        Contracts.assertNotNull((Object)boundingBox, (String)"boundingBox");
        return this.commonState.boundingBox(boundingBox);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (SearchPredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    private void generateWithinCircleQueryBuilders(GeoPoint center, double radius, DistanceUnit unit) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinCirclePredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinCircle(absoluteFieldPath);
            predicateBuilder.circle(center, radius, unit);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinPolygonQueryBuilders(GeoPolygon polygon) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinPolygonPredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinPolygon(absoluteFieldPath);
            predicateBuilder.polygon(polygon);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    private void generateWithinBoundingBoxQueryBuilders(GeoBoundingBox boundingBox) {
        for (String absoluteFieldPath : this.absoluteFieldPaths) {
            SpatialWithinBoundingBoxPredicateBuilder predicateBuilder = this.commonState.getFactory().spatialWithinBoundingBox(absoluteFieldPath);
            predicateBuilder.boundingBox(boundingBox);
            this.predicateBuilders.add(predicateBuilder);
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, SpatialWithinPredicateFieldSetContextImpl<B>>
    implements SpatialWithinPredicateTerminalContext {
        CommonState(SearchPredicateBuilderFactory<?, B> factory) {
            super(factory);
        }

        SpatialWithinPredicateTerminalContext circle(GeoPoint center, double radius, DistanceUnit unit) {
            for (SpatialWithinPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                fieldSetContext.generateWithinCircleQueryBuilders(center, radius, unit);
            }
            return this;
        }

        SpatialWithinPredicateTerminalContext polygon(GeoPolygon polygon) {
            for (SpatialWithinPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                fieldSetContext.generateWithinPolygonQueryBuilders(polygon);
            }
            return this;
        }

        SpatialWithinPredicateTerminalContext boundingBox(GeoBoundingBox boundingBox) {
            for (SpatialWithinPredicateFieldSetContextImpl fieldSetContext : this.getFieldSetContexts()) {
                fieldSetContext.generateWithinBoundingBoxQueryBuilders(boundingBox);
            }
            return this;
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

