package org.hibernate.search.engine.logging.impl;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.hibernate.search.engine.environment.classpath.spi.ClassLoadingException;
import org.hibernate.search.engine.mapper.model.spi.MappableTypeModel;
import org.hibernate.search.util.common.SearchException;
import java.lang.String;
import org.jboss.logging.Logger;
import java.lang.Exception;
import org.hibernate.search.util.common.reporting.EventContext;
import org.hibernate.search.engine.spatial.GeoPoint;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Object;
import java.util.Arrays;
import java.time.format.DateTimeFormatter;
import java.lang.IllegalArgumentException;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class Log_$logger extends DelegatingBasicLogger implements Log, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = Log_$logger.class.getName();
    public Log_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    private static final String noPublicNoArgConstructor = "HSEARCH000242: Hibernate Search failed to initialize component '%1$s' as class '%2$s' doesn't have a public no-arguments constructor";
    protected String noPublicNoArgConstructor$str() {
        return noPublicNoArgConstructor;
    }
    @Override
    public final SearchException noPublicNoArgConstructor(final String componentName, final Class<?> clazz) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noPublicNoArgConstructor$str(), componentName, new org.hibernate.search.util.common.logging.impl.ClassFormatter(clazz)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String simpleQueryStringCannotBeNull = "HSEARCH000334: Invalid simple query string: the string must be non-null. Null value was passed to simple query string predicate on fields %1$s.";
    protected String simpleQueryStringCannotBeNull$str() {
        return simpleQueryStringCannotBeNull;
    }
    @Override
    public final SearchException simpleQueryStringCannotBeNull(final java.util.Collection<String> strings) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), simpleQueryStringCannotBeNull$str(), strings));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToConvertConfigurationProperty = "HSEARCH000501: Unable to convert configuration property '%1$s' with value '%2$s': %3$s";
    protected String unableToConvertConfigurationProperty$str() {
        return unableToConvertConfigurationProperty;
    }
    @Override
    public final SearchException unableToConvertConfigurationProperty(final String key, final Object rawValue, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToConvertConfigurationProperty$str(), key, rawValue, errorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPropertyValue = "HSEARCH000502: Invalid value: expected either an instance of '%1$s' or a String that can be parsed. %2$s";
    protected String invalidPropertyValue$str() {
        return invalidPropertyValue;
    }
    @Override
    public final SearchException invalidPropertyValue(final Class<?> expectedType, final String errorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), errorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBooleanPropertyValue = "HSEARCH000503: Invalid Boolean value: expected either a Boolean, the String 'true' or the String 'false'. %1$s";
    protected String invalidBooleanPropertyValue$str() {
        return invalidBooleanPropertyValue;
    }
    @Override
    public final SearchException invalidBooleanPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBooleanPropertyValue$str(), nestedErrorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidIntegerPropertyValue = "HSEARCH000504: Invalid Integer value: expected either a Number or a String that can be parsed into an Integer. %1$s";
    protected String invalidIntegerPropertyValue$str() {
        return invalidIntegerPropertyValue;
    }
    @Override
    public final SearchException invalidIntegerPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidIntegerPropertyValue$str(), nestedErrorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidLongPropertyValue = "HSEARCH000505: Invalid Long value: expected either a Number or a String that can be parsed into a Long. %1$s";
    protected String invalidLongPropertyValue$str() {
        return invalidLongPropertyValue;
    }
    @Override
    public final SearchException invalidLongPropertyValue(final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidLongPropertyValue$str(), nestedErrorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidMultiPropertyValue = "HSEARCH000506: Invalid multi value: expected either a Collection or a String.";
    protected String invalidMultiPropertyValue$str() {
        return invalidMultiPropertyValue;
    }
    @Override
    public final SearchException invalidMultiPropertyValue() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidMultiPropertyValue$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddMultiplePredicatesToQueryRoot = "HSEARCH000507: Cannot add multiple predicates to the query root; use an explicit boolean predicate instead.";
    protected String cannotAddMultiplePredicatesToQueryRoot$str() {
        return cannotAddMultiplePredicatesToQueryRoot;
    }
    @Override
    public final SearchException cannotAddMultiplePredicatesToQueryRoot() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAddMultiplePredicatesToQueryRoot$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddMultiplePredicatesToNestedPredicate = "HSEARCH000509: Cannot add multiple predicates to a nested predicate; use an explicit boolean predicate instead.";
    protected String cannotAddMultiplePredicatesToNestedPredicate$str() {
        return cannotAddMultiplePredicatesToNestedPredicate;
    }
    @Override
    public final SearchException cannotAddMultiplePredicatesToNestedPredicate() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAddMultiplePredicatesToNestedPredicate$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String matchPredicateCannotMatchNullValue = "HSEARCH000511: Invalid value: the value to match in match predicates must be non-null.";
    protected String matchPredicateCannotMatchNullValue$str() {
        return matchPredicateCannotMatchNullValue;
    }
    @Override
    public final SearchException matchPredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), matchPredicateCannotMatchNullValue$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String rangePredicateCannotMatchNullValue = "HSEARCH000512: Invalid value: at least one bound in range predicates must be non-null.";
    protected String rangePredicateCannotMatchNullValue$str() {
        return rangePredicateCannotMatchNullValue;
    }
    @Override
    public final SearchException rangePredicateCannotMatchNullValue(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), rangePredicateCannotMatchNullValue$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotMapAbstractTypeToIndex = "HSEARCH000513: Cannot map type '%1$s' to index '%2$s', because this type is abstract. Index mappings are not inherited: they apply to exact instances of a given type. As a result, mapping an abstract type to an index does not make sense, since the index would always be empty.";
    protected String cannotMapAbstractTypeToIndex$str() {
        return cannotMapAbstractTypeToIndex;
    }
    @Override
    public final SearchException cannotMapAbstractTypeToIndex(final MappableTypeModel typeModel, final String indexName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotMapAbstractTypeToIndex$str(), new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(typeModel), indexName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String relativeFieldNameCannotBeNullOrEmpty = "HSEARCH000514: Field name '%1$s' is invalid: field names cannot be null or empty.";
    protected String relativeFieldNameCannotBeNullOrEmpty$str() {
        return relativeFieldNameCannotBeNullOrEmpty;
    }
    @Override
    public final SearchException relativeFieldNameCannotBeNullOrEmpty(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotBeNullOrEmpty$str(), relativeFieldName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String relativeFieldNameCannotContainDot = "HSEARCH000515: Field name '%1$s' is invalid: field names cannot contain a dot ('.'). Remove the dot from your field name, or if you are declaring the field in a bridge and want a tree of fields, declare an object field using the objectField() method.";
    protected String relativeFieldNameCannotContainDot$str() {
        return relativeFieldNameCannotContainDot;
    }
    @Override
    public final SearchException relativeFieldNameCannotContainDot(final String relativeFieldName, final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), relativeFieldNameCannotContainDot$str(), relativeFieldName), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidGeoPolygonFirstPointNotIdenticalToLastPoint = "HSEARCH000516: Invalid polygon: the first point '%1$s' should be identical to the last point '%2$s' to properly close the polygon.";
    protected String invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str() {
        return invalidGeoPolygonFirstPointNotIdenticalToLastPoint;
    }
    @Override
    public final IllegalArgumentException invalidGeoPolygonFirstPointNotIdenticalToLastPoint(final GeoPoint firstPoint, final GeoPoint lastPoint) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), invalidGeoPolygonFirstPointNotIdenticalToLastPoint$str(), firstPoint, lastPoint));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String cannotAddSortToUsedContext = "HSEARCH000518: Cannot add a sort to this DSL context anymore, because the DSL context was already closed. If you want to re-use sorts, do not re-use the sort DSL context objects, but rather build SearchSort objects.";
    protected String cannotAddSortToUsedContext$str() {
        return cannotAddSortToUsedContext;
    }
    @Override
    public final SearchException cannotAddSortToUsedContext() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotAddSortToUsedContext$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String boostrapCollectedFailureLimitReached = "HSEARCH000519: Hibernate Search bootstrap failed; stopped collecting failures after '%2$s' failures. Failures:\n%1$s";
    protected String boostrapCollectedFailureLimitReached$str() {
        return boostrapCollectedFailureLimitReached;
    }
    @Override
    public final SearchException boostrapCollectedFailureLimitReached(final String renderedFailures, final int failureCount) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), boostrapCollectedFailureLimitReached$str(), renderedFailures, failureCount));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String bootstrapCollectedFailures = "HSEARCH000520: Hibernate Search bootstrap failed. Failures:\n%1$s";
    protected String bootstrapCollectedFailures$str() {
        return bootstrapCollectedFailures;
    }
    @Override
    public final SearchException bootstrapCollectedFailures(final String renderedFailures) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), bootstrapCollectedFailures$str(), renderedFailures));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    @Override
    public final void newBootstrapCollectedFailure(final String context, final Throwable failure) {
        super.log.logf(FQCN, ERROR, failure, newBootstrapCollectedFailure$str(), context);
    }
    private static final String newBootstrapCollectedFailure = "HSEARCH000521: Hibernate Search bootstrap encountered a non-fatal failure; continuing bootstrap for now to list all mapping problems, but the bootstrap process will ultimately be aborted.\nContext: %1$s\nFailure:";
    protected String newBootstrapCollectedFailure$str() {
        return newBootstrapCollectedFailure;
    }
    @Override
    public final void unexpectedEmptyEventContext(final Throwable exceptionForStackTrace) {
        super.log.logf(FQCN, DEBUG, exceptionForStackTrace, unexpectedEmptyEventContext$str());
    }
    private static final String unexpectedEmptyEventContext = "HSEARCH000522: Unexpected empty event context; there is a bug in Hibernate Search, please report it";
    protected String unexpectedEmptyEventContext$str() {
        return unexpectedEmptyEventContext;
    }
    private static final String cannotCallDslExtensionIfSupportedAfterOrElse = "HSEARCH000525: Cannot call ifSupported(...) after orElse(...). Use a separate extension() context, or move the orElse(...) call last.";
    protected String cannotCallDslExtensionIfSupportedAfterOrElse$str() {
        return cannotCallDslExtensionIfSupportedAfterOrElse;
    }
    @Override
    public final SearchException cannotCallDslExtensionIfSupportedAfterOrElse() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), cannotCallDslExtensionIfSupportedAfterOrElse$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String dslExtensionNoMatch = "HSEARCH000526: None of the provided extensions can be applied to the current context.  Attempted extensions: %1$s. If you want to ignore this, use .extension().ifSupported(...).orElse(ignored -> { }).";
    protected String dslExtensionNoMatch$str() {
        return dslExtensionNoMatch;
    }
    @Override
    public final SearchException dslExtensionNoMatch(final java.util.List<?> attemptedExtensions) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), dslExtensionNoMatch$str(), attemptedExtensions));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateComponent = "HSEARCH000527: Unable to instantiate %1$s, class '%2$s': %3$s";
    protected String unableToInstantiateComponent$str() {
        return unableToInstantiateComponent;
    }
    @Override
    public final SearchException unableToInstantiateComponent(final String componentDescription, final Class<?> classToLoad, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateComponent$str(), componentDescription, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String securityManagerLoadingError = "HSEARCH000528: %2$s defined for component %1$s could not be instantiated because of a security manager error";
    protected String securityManagerLoadingError$str() {
        return securityManagerLoadingError;
    }
    @Override
    public final SearchException securityManagerLoadingError(final String componentDescription, final Class<?> classToLoad, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), securityManagerLoadingError$str(), componentDescription, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToFindComponentImplementation = "HSEARCH000529: Unable to find %1$s implementation class: %2$s";
    protected String unableToFindComponentImplementation$str() {
        return unableToFindComponentImplementation;
    }
    @Override
    public final SearchException unableToFindComponentImplementation(final String componentDescription, final String classNameToLoad, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToFindComponentImplementation$str(), componentDescription, classNameToLoad), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToLoadTheClass = "HSEARCH000530: Unable to load class [%1$s]";
    protected String unableToLoadTheClass$str() {
        return unableToLoadTheClass;
    }
    @Override
    public final ClassLoadingException unableToLoadTheClass(final String className, final Throwable cause) {
        final ClassLoadingException result = new ClassLoadingException(String.format(getLoggingLocale(), unableToLoadTheClass$str(), className), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String multipleIndexMapping = "HSEARCH000531: Trying to map the Type '%1$s' mapped to multiple indexes: '%2$s', '%3$s'.";
    protected String multipleIndexMapping$str() {
        return multipleIndexMapping;
    }
    @Override
    public final SearchException multipleIndexMapping(final MappableTypeModel typeModel, final String indexName, final String otherIndexName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), multipleIndexMapping$str(), new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(typeModel), indexName, otherIndexName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noMappingRegistered = "HSEARCH000532: No mapping registered for mapping key: '%1$s'.";
    protected String noMappingRegistered$str() {
        return noMappingRegistered;
    }
    @Override
    public final SearchException noMappingRegistered(final org.hibernate.search.engine.mapper.mapping.spi.MappingKey<?, ?> mappingKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noMappingRegistered$str(), new org.hibernate.search.engine.logging.spi.MappingKeyFormatter(mappingKey)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noBackendRegistered = "HSEARCH000533: No backend registered for backend name: '%1$s'.";
    protected String noBackendRegistered$str() {
        return noBackendRegistered;
    }
    @Override
    public final SearchException noBackendRegistered(final String backendName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noBackendRegistered$str(), backendName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String noIndexManagerRegistered = "HSEARCH000534: No index manager registered for index manager name: '%1$s'.";
    protected String noIndexManagerRegistered$str() {
        return noIndexManagerRegistered;
    }
    @Override
    public final SearchException noIndexManagerRegistered(final String indexManagerName) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), noIndexManagerRegistered$str(), indexManagerName));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToInstantiateClass = "HSEARCH000540: Unable to instantiate class '%1$s': %2$s.";
    protected String unableToInstantiateClass$str() {
        return unableToInstantiateClass;
    }
    @Override
    public final SearchException unableToInstantiateClass(final Class<?> classToLoad, final String causeMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToInstantiateClass$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), causeMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String interfaceImplementedExpected = "HSEARCH000541: Wrong configuration of %1$s: class %2$s does not implement interface %3$s.";
    protected String interfaceImplementedExpected$str() {
        return interfaceImplementedExpected;
    }
    @Override
    public final SearchException interfaceImplementedExpected(final String component, final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), interfaceImplementedExpected$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String subtypeExpected = "HSEARCH000542: Wrong configuration of %1$s: class %2$s is not a subtype of %3$s.";
    protected String subtypeExpected$str() {
        return subtypeExpected;
    }
    @Override
    public final SearchException subtypeExpected(final String component, final Class<?> classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), subtypeExpected$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad), new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String implementationRequired = "HSEARCH000543: %2$s defined for component %1$s is an interface: implementation required.";
    protected String implementationRequired$str() {
        return implementationRequired;
    }
    @Override
    public final SearchException implementationRequired(final String component, final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), implementationRequired$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String missingConstructor = "HSEARCH000544: %2$s defined for component %1$s is missing an appropriate constructor: expected a public constructor with a single parameter of type Map.";
    protected String missingConstructor$str() {
        return missingConstructor;
    }
    @Override
    public final SearchException missingConstructor(final String component, final Class<?> classToLoad) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), missingConstructor$str(), component, new org.hibernate.search.util.common.logging.impl.ClassFormatter(classToLoad)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String notAssignableImplementation = "HSEARCH000545: Unable to load class for %1$s. Configured implementation %2$s  is not assignable to type %3$s.";
    protected String notAssignableImplementation$str() {
        return notAssignableImplementation;
    }
    @Override
    public final SearchException notAssignableImplementation(final String component, final String classToLoad, final Class<?> superType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), notAssignableImplementation$str(), component, classToLoad, new org.hibernate.search.util.common.logging.impl.ClassFormatter(superType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String indexedEmbeddedCyclicRecursion = "HSEARCH000546: Found an infinite IndexedEmbedded recursion involving path '%1$s' on type '%2$s'.";
    protected String indexedEmbeddedCyclicRecursion$str() {
        return indexedEmbeddedCyclicRecursion;
    }
    @Override
    public final SearchException indexedEmbeddedCyclicRecursion(final String cyclicRecursionPath, final MappableTypeModel parentTypeModel) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), indexedEmbeddedCyclicRecursion$str(), cyclicRecursionPath, new org.hibernate.search.engine.logging.spi.MappableTypeModelFormatter(parentTypeModel)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBeanReferencePropertyValue = "HSEARCH000547: Invalid BeanReference value: expected an instance of '%1$s', BeanReference, String or Class. %2$s";
    protected String invalidBeanReferencePropertyValue$str() {
        return invalidBeanReferencePropertyValue;
    }
    @Override
    public final SearchException invalidBeanReferencePropertyValue(final Class<?> expectedType, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanReferencePropertyValue$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedType), nestedErrorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidBeanType = "HSEARCH000548: Invalid bean type: type '%2$s' is not assignable to '%1$s'.";
    protected String invalidBeanType$str() {
        return invalidBeanType;
    }
    @Override
    public final SearchException invalidBeanType(final Class<?> expectedSuperType, final Class<?> actualType) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidBeanType$str(), new org.hibernate.search.util.common.logging.impl.ClassFormatter(expectedSuperType), new org.hibernate.search.util.common.logging.impl.ClassFormatter(actualType)));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String backendTypeCannotBeNullOrEmpty = "HSEARCH000549: Missing backend type for backend '%1$s'. Set the property '%2$s' to a supported value.";
    protected String backendTypeCannotBeNullOrEmpty$str() {
        return backendTypeCannotBeNullOrEmpty;
    }
    @Override
    public final SearchException backendTypeCannotBeNullOrEmpty(final String backendName, final String key) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), backendTypeCannotBeNullOrEmpty$str(), backendName, key));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String defaultBackendNameNotSet = "HSEARCH000550: The name of the default backend is not set. Set it through the configuration property '%1$s', or set the backend name explicitly for each indexed type in your mapping.";
    protected String defaultBackendNameNotSet$str() {
        return defaultBackendNameNotSet;
    }
    @Override
    public final SearchException defaultBackendNameNotSet(final String defaultKey) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), defaultBackendNameNotSet$str(), defaultKey));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String perFieldBoostWithConstantScore = "HSEARCH000551: It is not possible to use per-field boosts together with withConstantScore option";
    protected String perFieldBoostWithConstantScore$str() {
        return perFieldBoostWithConstantScore;
    }
    @Override
    public final SearchException perFieldBoostWithConstantScore() {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), perFieldBoostWithConstantScore$str()));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String phrasePredicateCannotMatchNullPhrase = "HSEARCH000552: Invalid phrase: the phrase to match in phrase predicates must be non-null.";
    protected String phrasePredicateCannotMatchNullPhrase$str() {
        return phrasePredicateCannotMatchNullPhrase;
    }
    @Override
    public final SearchException phrasePredicateCannotMatchNullPhrase(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), phrasePredicateCannotMatchNullPhrase$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidPhrasePredicateSlop = "HSEARCH000553: Invalid slop: %1$d. The slop must be positive or zero.";
    protected String invalidPhrasePredicateSlop$str() {
        return invalidPhrasePredicateSlop;
    }
    @Override
    public final SearchException invalidPhrasePredicateSlop(final int slop) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidPhrasePredicateSlop$str(), slop));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidFuzzyMaximumEditDistance = "HSEARCH000554: Invalid maximum edit distance: %1$d. The value must be 0, 1 or 2.";
    protected String invalidFuzzyMaximumEditDistance$str() {
        return invalidFuzzyMaximumEditDistance;
    }
    @Override
    public final SearchException invalidFuzzyMaximumEditDistance(final int maximumEditDistance) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidFuzzyMaximumEditDistance$str(), maximumEditDistance));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidExactPrefixLength = "HSEARCH000555: Invalid exact prefix length: %1$d. The value must be positive or zero.";
    protected String invalidExactPrefixLength$str() {
        return invalidExactPrefixLength;
    }
    @Override
    public final SearchException invalidExactPrefixLength(final int exactPrefixLength) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidExactPrefixLength$str(), exactPrefixLength));
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String wildcardPredicateCannotMatchNullPattern = "HSEARCH000556: Invalid pattern: the pattern to match in wildcard predicates must be non-null.";
    protected String wildcardPredicateCannotMatchNullPattern$str() {
        return wildcardPredicateCannotMatchNullPattern;
    }
    @Override
    public final SearchException wildcardPredicateCannotMatchNullPattern(final EventContext context) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), wildcardPredicateCannotMatchNullPattern$str()), context);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String unableToParseTemporal = "HSEARCH000557: '%1$s' instance cannot be parsed from value: '%2$s', using the expected formatter: '%3$s'.";
    protected String unableToParseTemporal$str() {
        return unableToParseTemporal;
    }
    @Override
    public final SearchException unableToParseTemporal(final Class<? extends java.time.temporal.TemporalAccessor> type, final String value, final DateTimeFormatter formatter, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), unableToParseTemporal$str(), new org.hibernate.search.engine.logging.spi.SimpleNameClassFormatter(type), value, formatter), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidNumberPropertyValue = "HSEARCH000558: Invalid %1$s value: expected either a Number or a String that can be parsed into a %1$s. %2$s";
    protected String invalidNumberPropertyValue$str() {
        return invalidNumberPropertyValue;
    }
    @Override
    public final SearchException invalidNumberPropertyValue(final Class<? extends Number> type, final String nestedErrorMessage, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidNumberPropertyValue$str(), new org.hibernate.search.engine.logging.spi.SimpleNameClassFormatter(type), nestedErrorMessage), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStringForType = "HSEARCH000559: Invalid '%1$s' value for type '%2$s'.";
    protected String invalidStringForType$str() {
        return invalidStringForType;
    }
    @Override
    public final SearchException invalidStringForType(final String value, final Class<?> type, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForType$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(type)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
    private static final String invalidStringForEnum = "HSEARCH000560: Invalid '%1$s' value for enum '%2$s'.";
    protected String invalidStringForEnum$str() {
        return invalidStringForEnum;
    }
    @Override
    public final SearchException invalidStringForEnum(final String value, final Class<? extends Enum> enumType, final Exception cause) {
        final SearchException result = new SearchException(String.format(getLoggingLocale(), invalidStringForEnum$str(), value, new org.hibernate.search.util.common.logging.impl.ClassFormatter(enumType)), cause);
        final StackTraceElement[] st = result.getStackTrace();
        result.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
        return result;
    }
}
