/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Map;
import java.util.Optional;
import org.hibernate.search.engine.cfg.impl.EmptyConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.FallbackConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.MapConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.MaskedConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.OverriddenConfigurationPropertySource;
import org.hibernate.search.engine.cfg.impl.PrefixedConfigurationPropertySource;

public interface ConfigurationPropertySource {
    public Optional<?> get(String var1);

    public Optional<String> resolve(String var1);

    default public ConfigurationPropertySource withPrefix(String prefix) {
        return new PrefixedConfigurationPropertySource(this, prefix);
    }

    default public ConfigurationPropertySource withMask(String mask) {
        return new MaskedConfigurationPropertySource(this, mask);
    }

    default public ConfigurationPropertySource withFallback(ConfigurationPropertySource fallback) {
        return new FallbackConfigurationPropertySource(this, fallback);
    }

    default public ConfigurationPropertySource withOverride(ConfigurationPropertySource override) {
        return new OverriddenConfigurationPropertySource(this, override);
    }

    public static ConfigurationPropertySource fromMap(Map<String, ?> map) {
        return new MapConfigurationPropertySource(map);
    }

    public static ConfigurationPropertySource empty() {
        return EmptyConfigurationPropertySource.get();
    }
}

