/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFieldMoreStep;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateFromToStep;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateLastLimitExcludeStep;
import org.hibernate.search.engine.search.dsl.predicate.RangePredicateOptionsStep;
import org.hibernate.search.engine.search.dsl.predicate.impl.AbstractBooleanMultiFieldPredicateCommonState;
import org.hibernate.search.engine.search.predicate.DslConverter;
import org.hibernate.search.engine.search.predicate.spi.RangePredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class RangePredicateFieldMoreStepImpl<B>
implements RangePredicateFieldMoreStep,
AbstractBooleanMultiFieldPredicateCommonState.FieldSetState<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<RangePredicateBuilder<B>> predicateBuilders = new ArrayList<RangePredicateBuilder<B>>();
    private Float fieldSetBoost;

    RangePredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        SearchPredicateBuilderFactory predicateFactory = commonState.getFactory();
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.predicateBuilders.add(predicateFactory.range(absoluteFieldPath));
        }
    }

    @Override
    public RangePredicateFieldMoreStep orFields(String ... absoluteFieldPaths) {
        return new RangePredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public RangePredicateFieldMoreStep boostedTo(float boost) {
        this.fieldSetBoost = Float.valueOf(boost);
        return this;
    }

    @Override
    public RangePredicateFromToStep from(Object value, DslConverter dslConverter) {
        return this.commonState.from(value, dslConverter);
    }

    @Override
    public RangePredicateLastLimitExcludeStep above(Object value, DslConverter dslConverter) {
        return this.commonState.above(value, dslConverter);
    }

    @Override
    public RangePredicateLastLimitExcludeStep below(Object value, DslConverter dslConverter) {
        return this.commonState.below(value, dslConverter);
    }

    @Override
    public List<String> getAbsoluteFieldPaths() {
        return this.absoluteFieldPaths;
    }

    @Override
    public void contributePredicateBuilders(Consumer<B> collector) {
        for (RangePredicateBuilder<B> predicateBuilder : this.predicateBuilders) {
            this.commonState.applyBoostAndConstantScore(this.fieldSetBoost, predicateBuilder);
            collector.accept(predicateBuilder.toImplementation());
        }
    }

    static class RangePredicateFromToStepImpl<B>
    implements RangePredicateFromToStep {
        private final CommonState<B> delegate;

        RangePredicateFromToStepImpl(CommonState<B> delegate) {
            this.delegate = delegate;
        }

        @Override
        public RangePredicateLastLimitExcludeStep to(Object value, DslConverter dslConverter) {
            ((CommonState)this.delegate).doBelow(value, dslConverter);
            ((CommonState)this.delegate).checkHasNonNullBound();
            return this.delegate;
        }

        @Override
        public RangePredicateFromToStep excludeLimit() {
            ((CommonState)this.delegate).getQueryBuilders().forEach(RangePredicateBuilder::excludeLowerLimit);
            return this;
        }
    }

    static class CommonState<B>
    extends AbstractBooleanMultiFieldPredicateCommonState<CommonState<B>, B, RangePredicateFieldMoreStepImpl<B>>
    implements RangePredicateLastLimitExcludeStep {
        private boolean hasNonNullBound = false;
        protected boolean excludeUpperLimit = false;

        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
        }

        @Override
        public RangePredicateOptionsStep excludeLimit() {
            this.getQueryBuilders().forEach(this.excludeUpperLimit ? RangePredicateBuilder::excludeUpperLimit : RangePredicateBuilder::excludeLowerLimit);
            return this;
        }

        @Override
        protected B toImplementation() {
            this.checkHasNonNullBound();
            return super.toImplementation();
        }

        RangePredicateFromToStep from(Object value, DslConverter dslConverter) {
            this.doAbove(value, dslConverter);
            return new RangePredicateFromToStepImpl(this);
        }

        RangePredicateLastLimitExcludeStep above(Object value, DslConverter dslConverter) {
            this.doAbove(value, dslConverter);
            this.checkHasNonNullBound();
            return this;
        }

        RangePredicateLastLimitExcludeStep below(Object value, DslConverter dslConverter) {
            this.doBelow(value, dslConverter);
            this.checkHasNonNullBound();
            return this;
        }

        private void doAbove(Object value, DslConverter dslConverter) {
            this.excludeUpperLimit = false;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.lowerLimit(value, dslConverter));
            }
        }

        private void doBelow(Object value, DslConverter dslConverter) {
            this.excludeUpperLimit = true;
            if (value != null) {
                this.hasNonNullBound = true;
                this.getQueryBuilders().forEach(q -> q.upperLimit(value, dslConverter));
            }
        }

        private void checkHasNonNullBound() {
            if (!this.hasNonNullBound) {
                throw log.rangePredicateCannotMatchNullValue(this.getEventContext());
            }
        }

        private Stream<RangePredicateBuilder<B>> getQueryBuilders() {
            return this.getFieldSetStates().stream().flatMap(f -> ((RangePredicateFieldMoreStepImpl)f).predicateBuilders.stream());
        }

        @Override
        protected CommonState<B> thisAsS() {
            return this;
        }
    }
}

