/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.dsl.predicate.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.search.dsl.predicate.SimpleQueryStringPredicateFieldMoreStep;
import org.hibernate.search.engine.search.dsl.predicate.SimpleQueryStringPredicateOptionsStep;
import org.hibernate.search.engine.search.dsl.predicate.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.engine.search.predicate.spi.SimpleQueryStringPredicateBuilder;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

class SimpleQueryStringPredicateFieldMoreStepImpl<B>
implements SimpleQueryStringPredicateFieldMoreStep {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final CommonState<B> commonState;
    private final List<String> absoluteFieldPaths;
    private final List<SimpleQueryStringPredicateBuilder.FieldState> fieldStates = new ArrayList<SimpleQueryStringPredicateBuilder.FieldState>();

    SimpleQueryStringPredicateFieldMoreStepImpl(CommonState<B> commonState, List<String> absoluteFieldPaths) {
        this.commonState = commonState;
        this.commonState.add(this);
        this.absoluteFieldPaths = absoluteFieldPaths;
        for (String absoluteFieldPath : absoluteFieldPaths) {
            this.fieldStates.add(commonState.field(absoluteFieldPath));
        }
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStep orFields(String ... absoluteFieldPaths) {
        return new SimpleQueryStringPredicateFieldMoreStepImpl<B>(this.commonState, Arrays.asList(absoluteFieldPaths));
    }

    @Override
    public SimpleQueryStringPredicateFieldMoreStep boostedTo(float boost) {
        this.fieldStates.forEach(c -> c.boost(boost));
        return this;
    }

    @Override
    public SimpleQueryStringPredicateOptionsStep matching(String simpleQueryString) {
        return ((CommonState)this.commonState).matching(simpleQueryString);
    }

    static class CommonState<B>
    extends AbstractPredicateFinalStep<B>
    implements SimpleQueryStringPredicateOptionsStep {
        private final SimpleQueryStringPredicateBuilder<B> builder;
        private final List<SimpleQueryStringPredicateFieldMoreStepImpl<B>> fieldSetStates = new ArrayList<SimpleQueryStringPredicateFieldMoreStepImpl<B>>();

        CommonState(SearchPredicateBuilderFactory<?, B> builderFactory) {
            super(builderFactory);
            this.builder = builderFactory.simpleQueryString();
        }

        @Override
        protected B toImplementation() {
            return this.builder.toImplementation();
        }

        void add(SimpleQueryStringPredicateFieldMoreStepImpl<B> fieldSetState) {
            this.fieldSetStates.add(fieldSetState);
        }

        SimpleQueryStringPredicateBuilder.FieldState field(String absoluteFieldPath) {
            return this.builder.field(absoluteFieldPath);
        }

        private SimpleQueryStringPredicateOptionsStep matching(String simpleQueryString) {
            if (simpleQueryString == null) {
                throw log.simpleQueryStringCannotBeNull(this.collectAbsoluteFieldPaths());
            }
            this.builder.simpleQueryString(simpleQueryString);
            return this;
        }

        @Override
        public CommonState<B> withConstantScore() {
            this.builder.withConstantScore();
            return this;
        }

        @Override
        public CommonState<B> boostedTo(float boost) {
            this.builder.boost(boost);
            return this;
        }

        @Override
        public SimpleQueryStringPredicateOptionsStep withAndAsDefaultOperator() {
            this.builder.withAndAsDefaultOperator();
            return this;
        }

        @Override
        public SimpleQueryStringPredicateOptionsStep analyzer(String analyzerName) {
            this.builder.analyzer(analyzerName);
            return this;
        }

        @Override
        public SimpleQueryStringPredicateOptionsStep skipAnalysis() {
            this.builder.skipAnalysis();
            return this;
        }

        private List<String> collectAbsoluteFieldPaths() {
            return this.fieldSetStates.stream().flatMap(f -> ((SimpleQueryStringPredicateFieldMoreStepImpl)f).absoluteFieldPaths.stream()).collect(Collectors.toList());
        }
    }
}

