/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.cfg.spi;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertySource;

public final class ConsumedPropertyTrackingConfigurationPropertySource
implements ConfigurationPropertySource {
    private final ConfigurationPropertySource delegate;
    private final Set<String> consumedPropertyKeys;

    public ConsumedPropertyTrackingConfigurationPropertySource(ConfigurationPropertySource delegate) {
        this.delegate = delegate;
        this.consumedPropertyKeys = ConcurrentHashMap.newKeySet();
    }

    @Override
    public Optional<?> get(String key) {
        Optional<String> resolved = this.resolve(key);
        if (resolved.isPresent()) {
            this.consumedPropertyKeys.add(resolved.get());
        }
        return this.delegate.get(key);
    }

    @Override
    public Optional<String> resolve(String key) {
        return this.delegate.resolve(key);
    }

    public Set<String> getConsumedPropertyKeys() {
        return Collections.unmodifiableSet(this.consumedPropertyKeys);
    }
}

