/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import org.hibernate.search.engine.backend.scope.spi.IndexScope;
import org.hibernate.search.engine.mapper.scope.spi.MappedIndexScope;
import org.hibernate.search.engine.mapper.session.context.spi.SessionContextImplementor;
import org.hibernate.search.engine.search.dsl.predicate.SearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.predicate.impl.DefaultSearchPredicateFactory;
import org.hibernate.search.engine.search.dsl.projection.SearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.projection.impl.DefaultSearchProjectionFactory;
import org.hibernate.search.engine.search.dsl.query.SearchQueryHitTypeStep;
import org.hibernate.search.engine.search.dsl.query.impl.DefaultSearchQueryHitTypeStep;
import org.hibernate.search.engine.search.dsl.sort.SearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.impl.DefaultSearchSortFactory;
import org.hibernate.search.engine.search.dsl.sort.impl.SearchSortDslContextImpl;
import org.hibernate.search.engine.search.loading.context.spi.LoadingContextBuilder;

class MappedIndexScopeImpl<C, R, E>
implements MappedIndexScope<R, E> {
    private final IndexScope<C> delegate;

    MappedIndexScopeImpl(IndexScope<C> delegate) {
        this.delegate = delegate;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + "delegate=" + this.delegate + "]";
    }

    @Override
    public SearchQueryHitTypeStep<?, R, E, SearchProjectionFactory<R, E>, ?> search(SessionContextImplementor sessionContext, LoadingContextBuilder<R, E> loadingContextBuilder) {
        return new DefaultSearchQueryHitTypeStep<R, E, C>(this.delegate, sessionContext, loadingContextBuilder);
    }

    @Override
    public SearchPredicateFactory predicate() {
        return new DefaultSearchPredicateFactory(this.delegate.getSearchPredicateBuilderFactory());
    }

    @Override
    public SearchSortFactory sort() {
        return new DefaultSearchSortFactory(SearchSortDslContextImpl.root(this.delegate.getSearchSortBuilderFactory()));
    }

    @Override
    public SearchProjectionFactory<R, E> projection() {
        return new DefaultSearchProjectionFactory(this.delegate.getSearchProjectionFactory());
    }
}

