/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.spi;

import org.hibernate.search.engine.common.spi.ContextualErrorHandler;
import org.hibernate.search.engine.common.spi.ErrorContextBuilder;
import org.hibernate.search.engine.common.spi.ErrorHandler;

class DefaultContextualErrorHandler
implements ContextualErrorHandler {
    private final ErrorHandler errorHandler;
    private ErrorContextBuilder errorContextBuilder;
    private Throwable errorThatOccurred;

    DefaultContextualErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    @Override
    public void markAsFailed(Object workInfo, Throwable throwable) {
        if (workInfo != null) {
            this.getErrorContextBuilder().operationAtFault(workInfo);
            this.getErrorContextBuilder().addWorkThatFailed(workInfo);
        }
        this.addThrowable(throwable);
    }

    @Override
    public void markAsSkipped(Object workInfo) {
        if (workInfo != null) {
            this.getErrorContextBuilder().addWorkThatFailed(workInfo);
        }
    }

    @Override
    public void addThrowable(Throwable throwable) {
        if (this.errorThatOccurred == null) {
            this.errorThatOccurred = throwable;
        } else {
            this.errorThatOccurred.addSuppressed(throwable);
        }
    }

    @Override
    public void handle() {
        if (this.errorContextBuilder != null || this.errorThatOccurred != null) {
            if (this.errorThatOccurred != null) {
                this.getErrorContextBuilder().errorThatOccurred(this.errorThatOccurred);
            }
            this.errorHandler.handle(this.getErrorContextBuilder().createErrorContext());
        }
    }

    private ErrorContextBuilder getErrorContextBuilder() {
        if (this.errorContextBuilder == null) {
            this.errorContextBuilder = new ErrorContextBuilder();
        }
        return this.errorContextBuilder;
    }
}

