/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.environment.thread.impl;

import java.lang.invoke.MethodHandles;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.thread.spi.ThreadPoolProvider;
import org.hibernate.search.engine.environment.thread.spi.ThreadProvider;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.logging.impl.Log;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;

public final class ThreadPoolProviderImpl
implements ThreadPoolProvider {
    private static final int QUEUE_MAX_LENGTH = 1000;
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final BeanHolder<? extends ThreadProvider> threadProviderHolder;

    public ThreadPoolProviderImpl(BeanHolder<? extends ThreadProvider> threadProviderHolder) {
        this.threadProviderHolder = threadProviderHolder;
    }

    public void close() {
        try (Closer closer = new Closer();){
            closer.push(BeanHolder::close, this.threadProviderHolder);
        }
    }

    @Override
    public ThreadProvider getThreadProvider() {
        return this.threadProviderHolder.get();
    }

    @Override
    public ThreadPoolExecutor newFixedThreadPool(int threads, String threadNamePrefix) {
        return this.newFixedThreadPool(threads, threadNamePrefix, 1000);
    }

    @Override
    public ThreadPoolExecutor newFixedThreadPool(int threads, String threadNamePrefix, int queueSize) {
        return new ThreadPoolExecutor(threads, threads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(queueSize), this.threadProviderHolder.get().createThreadFactory(threadNamePrefix), new BlockPolicy());
    }

    @Override
    public ScheduledExecutorService newScheduledExecutor(int threads, String threadNamePrefix) {
        ScheduledThreadPoolExecutor result = new ScheduledThreadPoolExecutor(threads, this.threadProviderHolder.get().createThreadFactory(threadNamePrefix), new BlockPolicy());
        result.setRemoveOnCancelPolicy(true);
        return result;
    }

    public static class BlockPolicy
    implements RejectedExecutionHandler {
        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
            try {
                e.getQueue().put(r);
            }
            catch (InterruptedException e1) {
                log.interruptedWorkError(r);
                Thread.currentThread().interrupt();
            }
        }
    }
}

