/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.aggregation.dsl.impl;

import java.util.Map;
import java.util.function.Function;
import org.hibernate.search.engine.search.aggregation.SearchAggregation;
import org.hibernate.search.engine.search.aggregation.dsl.TermsAggregationOptionsStep;
import org.hibernate.search.engine.search.aggregation.dsl.spi.SearchAggregationDslContext;
import org.hibernate.search.engine.search.aggregation.spi.TermsAggregationBuilder;
import org.hibernate.search.engine.search.predicate.SearchPredicate;
import org.hibernate.search.engine.search.predicate.dsl.PredicateFinalStep;
import org.hibernate.search.engine.search.predicate.dsl.SearchPredicateFactory;
import org.hibernate.search.util.common.impl.Contracts;

class TermsAggregationOptionsStepImpl<PDF extends SearchPredicateFactory, F>
implements TermsAggregationOptionsStep<TermsAggregationOptionsStepImpl<PDF, F>, PDF, F, Map<F, Long>> {
    private final TermsAggregationBuilder<F> builder;
    private final SearchAggregationDslContext<?, ? extends PDF> dslContext;

    TermsAggregationOptionsStepImpl(TermsAggregationBuilder<F> builder, SearchAggregationDslContext<?, ? extends PDF> dslContext) {
        this.builder = builder;
        this.dslContext = dslContext;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> orderByCountDescending() {
        this.builder.orderByCountDescending();
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> orderByCountAscending() {
        this.builder.orderByCountAscending();
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> orderByTermAscending() {
        this.builder.orderByTermAscending();
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> orderByTermDescending() {
        this.builder.orderByTermDescending();
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> minDocumentCount(int minDocumentCount) {
        Contracts.assertPositiveOrZero((int)minDocumentCount, (String)"minDocumentCount");
        this.builder.minDocumentCount(minDocumentCount);
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> maxTermCount(int maxTermCount) {
        Contracts.assertStrictlyPositive((int)maxTermCount, (String)"maxTermCount");
        this.builder.maxTermCount(maxTermCount);
        return this;
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> filter(Function<? super PDF, ? extends PredicateFinalStep> clauseContributor) {
        SearchPredicate predicate = clauseContributor.apply(this.dslContext.getPredicateFactory()).toPredicate();
        return this.filter(predicate);
    }

    @Override
    public TermsAggregationOptionsStepImpl<PDF, F> filter(SearchPredicate searchPredicate) {
        this.builder.filter(searchPredicate);
        return this;
    }

    @Override
    public SearchAggregation<Map<F, Long>> toAggregation() {
        return this.builder.build();
    }
}

