/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.search.predicate.dsl.impl;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.hibernate.search.engine.logging.impl.Log;
import org.hibernate.search.engine.reporting.spi.EventContexts;
import org.hibernate.search.engine.search.predicate.dsl.spi.AbstractPredicateFinalStep;
import org.hibernate.search.engine.search.predicate.spi.BooleanPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilder;
import org.hibernate.search.engine.search.predicate.spi.SearchPredicateBuilderFactory;
import org.hibernate.search.util.common.logging.impl.LoggerFactory;
import org.hibernate.search.util.common.reporting.EventContext;

abstract class AbstractBooleanMultiFieldPredicateCommonState<S extends AbstractBooleanMultiFieldPredicateCommonState<?, ?, ?>, B, F extends FieldSetState<B>>
extends AbstractPredicateFinalStep<B> {
    private static final Log log = (Log)LoggerFactory.make(Log.class, (MethodHandles.Lookup)MethodHandles.lookup());
    private final List<F> fieldSetStates = new ArrayList<F>();
    private Float predicateLevelBoost;
    private boolean withConstantScore = false;

    AbstractBooleanMultiFieldPredicateCommonState(SearchPredicateBuilderFactory<?, B> factory) {
        super(factory);
    }

    public SearchPredicateBuilderFactory<?, B> getFactory() {
        return this.builderFactory;
    }

    public void add(F fieldSetState) {
        this.fieldSetStates.add(fieldSetState);
    }

    List<F> getFieldSetStates() {
        return this.fieldSetStates;
    }

    public S boost(float boost) {
        this.predicateLevelBoost = Float.valueOf(boost);
        return this.thisAsS();
    }

    public S constantScore() {
        this.withConstantScore = true;
        return this.thisAsS();
    }

    @Override
    protected B toImplementation() {
        ArrayList predicateBuilders = new ArrayList();
        for (FieldSetState fieldSetState : this.fieldSetStates) {
            fieldSetState.contributePredicateBuilders(predicateBuilders::add);
        }
        if (predicateBuilders.size() > 1) {
            BooleanPredicateBuilder boolBuilder = this.builderFactory.bool();
            for (Object predicateBuilder : predicateBuilders) {
                boolBuilder.should(predicateBuilder);
            }
            return boolBuilder.toImplementation();
        }
        return (B)predicateBuilders.get(0);
    }

    protected abstract S thisAsS();

    final void applyBoostAndConstantScore(Float fieldSetBoost, SearchPredicateBuilder<?> predicateBuilder) {
        if (fieldSetBoost != null && this.withConstantScore) {
            throw log.perFieldBoostWithConstantScore();
        }
        if (this.predicateLevelBoost != null && fieldSetBoost != null) {
            predicateBuilder.boost(this.predicateLevelBoost.floatValue() * fieldSetBoost.floatValue());
        } else if (this.predicateLevelBoost != null) {
            predicateBuilder.boost(this.predicateLevelBoost.floatValue());
        } else if (fieldSetBoost != null) {
            predicateBuilder.boost(fieldSetBoost.floatValue());
        }
        if (this.withConstantScore) {
            predicateBuilder.constantScore();
        }
    }

    protected final EventContext getEventContext() {
        return EventContexts.fromIndexFieldAbsolutePaths(this.getFieldSetStates().stream().flatMap(f -> f.getAbsoluteFieldPaths().stream()).collect(Collectors.toList()));
    }

    public static interface FieldSetState<B> {
        public List<String> getAbsoluteFieldPaths();

        public void contributePredicateBuilders(Consumer<B> var1);
    }
}

