/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.common.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.hibernate.search.engine.backend.index.spi.IndexManagerImplementor;
import org.hibernate.search.engine.backend.spi.BackendImplementor;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.cfg.spi.ConfigurationPropertyChecker;
import org.hibernate.search.engine.common.impl.BackendNonStartedState;
import org.hibernate.search.engine.common.impl.IndexManagerNonStartedState;
import org.hibernate.search.engine.common.impl.MappingFinalizationContextImpl;
import org.hibernate.search.engine.common.impl.MappingNonStartedState;
import org.hibernate.search.engine.common.impl.SearchIntegrationImpl;
import org.hibernate.search.engine.common.resources.impl.EngineThreads;
import org.hibernate.search.engine.common.spi.SearchIntegration;
import org.hibernate.search.engine.common.spi.SearchIntegrationFinalizer;
import org.hibernate.search.engine.common.spi.SearchIntegrationPartialBuildState;
import org.hibernate.search.engine.common.timing.spi.TimingSource;
import org.hibernate.search.engine.environment.bean.BeanHolder;
import org.hibernate.search.engine.environment.bean.BeanResolver;
import org.hibernate.search.engine.environment.bean.spi.BeanProvider;
import org.hibernate.search.engine.environment.thread.impl.ThreadPoolProviderImpl;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingFinalizer;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingKey;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingPartialBuildState;
import org.hibernate.search.engine.mapper.mapping.spi.MappingImplementor;
import org.hibernate.search.engine.reporting.FailureHandler;
import org.hibernate.search.engine.reporting.impl.EngineEventContextMessages;
import org.hibernate.search.engine.reporting.spi.RootFailureCollector;
import org.hibernate.search.util.common.AssertionFailure;
import org.hibernate.search.util.common.impl.Closer;
import org.hibernate.search.util.common.impl.Futures;

class SearchIntegrationPartialBuildStateImpl
implements SearchIntegrationPartialBuildState {
    private final BeanProvider beanProvider;
    private final BeanResolver beanResolver;
    private final BeanHolder<? extends FailureHandler> failureHandlerHolder;
    private final ThreadPoolProviderImpl threadPoolProvider;
    private final Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings;
    private final Map<String, BackendNonStartedState> nonStartedBackends;
    private final Map<String, IndexManagerNonStartedState> nonStartedIndexManagers;
    private final ConfigurationPropertyChecker partialConfigurationPropertyChecker;
    private final Map<MappingKey<?, ?>, MappingNonStartedState> fullyBuiltNonStartedMappings = new LinkedHashMap();
    private final Map<String, BackendImplementor> startedBackends = new LinkedHashMap<String, BackendImplementor>();
    private final Map<String, IndexManagerImplementor> startedIndexManagers = new LinkedHashMap<String, IndexManagerImplementor>();
    private final Map<MappingKey<?, ?>, MappingImplementor<?>> fullyBuiltStartedMappings = new LinkedHashMap();
    private final EngineThreads engineThreads;
    private final TimingSource timingSource;

    SearchIntegrationPartialBuildStateImpl(BeanProvider beanProvider, BeanResolver beanResolver, BeanHolder<? extends FailureHandler> failureHandlerHolder, ThreadPoolProviderImpl threadPoolProvider, Map<MappingKey<?, ?>, MappingPartialBuildState> partiallyBuiltMappings, Map<String, BackendNonStartedState> nonStartedBackends, Map<String, IndexManagerNonStartedState> nonStartedIndexManagers, ConfigurationPropertyChecker partialConfigurationPropertyChecker, EngineThreads engineThreads, TimingSource timingSource) {
        this.beanProvider = beanProvider;
        this.beanResolver = beanResolver;
        this.failureHandlerHolder = failureHandlerHolder;
        this.threadPoolProvider = threadPoolProvider;
        this.partiallyBuiltMappings = partiallyBuiltMappings;
        this.nonStartedBackends = nonStartedBackends;
        this.nonStartedIndexManagers = nonStartedIndexManagers;
        this.partialConfigurationPropertyChecker = partialConfigurationPropertyChecker;
        this.engineThreads = engineThreads;
        this.timingSource = timingSource;
    }

    @Override
    public void closeOnFailure() {
        try (Closer closer = new Closer();){
            closer.pushAll(MappingPartialBuildState::closeOnFailure, this.partiallyBuiltMappings.values());
            closer.pushAll(MappingNonStartedState::closeOnFailure, this.fullyBuiltNonStartedMappings.values());
            closer.pushAll(MappingImplementor::stop, this.fullyBuiltStartedMappings.values());
            closer.pushAll(IndexManagerNonStartedState::closeOnFailure, this.nonStartedIndexManagers.values());
            closer.pushAll(IndexManagerImplementor::stop, this.startedIndexManagers.values());
            closer.pushAll(BackendNonStartedState::closeOnFailure, this.nonStartedBackends.values());
            closer.pushAll(BackendImplementor::stop, this.startedBackends.values());
            closer.pushAll(ThreadPoolProviderImpl::close, (Object[])new ThreadPoolProviderImpl[]{this.threadPoolProvider});
            closer.pushAll(BeanHolder::close, (Object[])new BeanHolder[]{this.failureHandlerHolder});
            closer.pushAll(BeanProvider::close, (Object[])new BeanProvider[]{this.beanProvider});
            closer.pushAll(EngineThreads::onStop, (Object[])new EngineThreads[]{this.engineThreads});
            closer.pushAll(TimingSource::stop, (Object[])new TimingSource[]{this.timingSource});
        }
    }

    @Override
    public SearchIntegrationFinalizer finalizer(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker configurationPropertyChecker) {
        return new SearchIntegrationFinalizerImpl(propertySource.withMask("hibernate.search"), configurationPropertyChecker);
    }

    private class SearchIntegrationFinalizerImpl
    implements SearchIntegrationFinalizer {
        private final ConfigurationPropertySource propertySource;
        private final ConfigurationPropertyChecker propertyChecker;

        private SearchIntegrationFinalizerImpl(ConfigurationPropertySource propertySource, ConfigurationPropertyChecker propertyChecker) {
            this.propertySource = propertySource;
            this.propertyChecker = propertyChecker;
        }

        @Override
        public <PBM, M> M finalizeMapping(MappingKey<PBM, M> mappingKey, MappingFinalizer<PBM, M> finalizer) {
            Object partiallyBuiltMapping = SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.get(mappingKey);
            if (partiallyBuiltMapping == null) {
                throw new AssertionFailure("Some partially built mapping could not be found during bootstrap. Key: " + mappingKey);
            }
            MappingFinalizationContextImpl mappingFinalizationContext = new MappingFinalizationContextImpl(this.propertySource, SearchIntegrationPartialBuildStateImpl.this.beanResolver);
            MappingImplementor<M> mapping = finalizer.finalizeMapping(mappingFinalizationContext, partiallyBuiltMapping);
            SearchIntegrationPartialBuildStateImpl.this.fullyBuiltNonStartedMappings.put(mappingKey, new MappingNonStartedState(mappingKey, mapping));
            SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.remove(mappingKey);
            return mapping.toConcreteType();
        }

        @Override
        public SearchIntegration finalizeIntegration() {
            if (!SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings.isEmpty()) {
                throw new AssertionFailure("Some mappings were not fully built. Partially built mappings: " + SearchIntegrationPartialBuildStateImpl.this.partiallyBuiltMappings);
            }
            RootFailureCollector failureCollector = new RootFailureCollector(EngineEventContextMessages.INSTANCE.bootstrap());
            for (Map.Entry entry : SearchIntegrationPartialBuildStateImpl.this.nonStartedBackends.entrySet()) {
                SearchIntegrationPartialBuildStateImpl.this.startedBackends.put((String)entry.getKey(), ((BackendNonStartedState)entry.getValue()).start(failureCollector, SearchIntegrationPartialBuildStateImpl.this.beanResolver, this.propertySource, SearchIntegrationPartialBuildStateImpl.this.threadPoolProvider));
            }
            failureCollector.checkNoFailure();
            for (Map.Entry entry : SearchIntegrationPartialBuildStateImpl.this.nonStartedIndexManagers.entrySet()) {
                SearchIntegrationPartialBuildStateImpl.this.startedIndexManagers.put((String)entry.getKey(), ((IndexManagerNonStartedState)entry.getValue()).start(failureCollector, SearchIntegrationPartialBuildStateImpl.this.beanResolver, this.propertySource));
            }
            failureCollector.checkNoFailure();
            CompletableFuture[] mappingFutures = new CompletableFuture[SearchIntegrationPartialBuildStateImpl.this.fullyBuiltNonStartedMappings.size()];
            int mappingIndex = 0;
            for (MappingNonStartedState mappingNonStartedState : SearchIntegrationPartialBuildStateImpl.this.fullyBuiltNonStartedMappings.values()) {
                mappingFutures[mappingIndex] = mappingNonStartedState.start(failureCollector, SearchIntegrationPartialBuildStateImpl.this.beanResolver, this.propertySource, SearchIntegrationPartialBuildStateImpl.this.threadPoolProvider);
                ++mappingIndex;
            }
            Futures.unwrappedExceptionJoin(CompletableFuture.allOf(mappingFutures));
            failureCollector.checkNoFailure();
            for (Map.Entry entry : SearchIntegrationPartialBuildStateImpl.this.fullyBuiltNonStartedMappings.entrySet()) {
                SearchIntegrationPartialBuildStateImpl.this.fullyBuiltStartedMappings.put((MappingKey)entry.getKey(), ((MappingNonStartedState)entry.getValue()).getMapping());
            }
            this.propertyChecker.afterBoot(SearchIntegrationPartialBuildStateImpl.this.partialConfigurationPropertyChecker);
            return new SearchIntegrationImpl(SearchIntegrationPartialBuildStateImpl.this.beanProvider, SearchIntegrationPartialBuildStateImpl.this.failureHandlerHolder, SearchIntegrationPartialBuildStateImpl.this.threadPoolProvider, SearchIntegrationPartialBuildStateImpl.this.fullyBuiltStartedMappings, SearchIntegrationPartialBuildStateImpl.this.startedBackends, SearchIntegrationPartialBuildStateImpl.this.startedIndexManagers, SearchIntegrationPartialBuildStateImpl.this.engineThreads, SearchIntegrationPartialBuildStateImpl.this.timingSource);
        }
    }
}

