/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.mapper.mapping.building.impl;

class DepthFilter {
    private static final DepthFilter UNCONSTRAINED = new DepthFilter(null);
    private final Integer includeDepth;

    static DepthFilter unconstrained() {
        return UNCONSTRAINED;
    }

    static DepthFilter of(Integer includeDepth) {
        return new DepthFilter(includeDepth);
    }

    private DepthFilter(Integer includeDepth) {
        this.includeDepth = includeDepth;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[includeDepth=" + this.includeDepth + "]";
    }

    boolean isEveryPathIncludedAtDepth(int relativeDepth) {
        return this.includeDepth == null || this.includeDepth > relativeDepth;
    }

    boolean hasDepthLimit() {
        return this.includeDepth != null;
    }
}

