/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.mapper.javabean.impl;

import java.util.LinkedHashSet;
import java.util.Set;
import org.hibernate.search.engine.cfg.ConfigurationPropertySource;
import org.hibernate.search.engine.mapper.mapping.building.spi.MappingConfigurationCollector;
import org.hibernate.search.engine.mapper.mapping.spi.MappingBuildContext;
import org.hibernate.search.mapper.javabean.impl.JavaBeanEntityTypeContributor;
import org.hibernate.search.mapper.javabean.model.impl.JavaBeanBootstrapIntrospector;
import org.hibernate.search.mapper.pojo.mapping.building.spi.PojoTypeMetadataContributor;
import org.hibernate.search.mapper.pojo.mapping.spi.PojoMappingConfigurationContributor;

class JavaBeanTypeConfigurationContributor
implements PojoMappingConfigurationContributor {
    private final JavaBeanBootstrapIntrospector introspector;
    private final Set<Class<?>> entityTypes = new LinkedHashSet();

    public JavaBeanTypeConfigurationContributor(JavaBeanBootstrapIntrospector introspector) {
        this.introspector = introspector;
    }

    public void configure(MappingBuildContext buildContext, ConfigurationPropertySource propertySource, MappingConfigurationCollector<PojoTypeMetadataContributor> configurationCollector) {
        for (Class<?> type : this.entityTypes) {
            configurationCollector.collectContributor(this.introspector.getTypeModel(type), (Object)new JavaBeanEntityTypeContributor());
        }
    }

    void addEntityType(Class<?> type) {
        this.entityTypes.add(type);
    }
}

